<?php
/*
Project: DBone (http://dbone.us/)
Version: 5.0.1
Summary: PHP-based admin tool to manage PDO databases on the web.
Last updated: 2023-03-10
Developers:
	- Ron Ludwig (ron@ludwig.com)

Copyright (C) 2023 - DBone - All Rights Reserved

This program is free software. You can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 or later of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

Refer to the GNU General Public License at:
	https://www.gnu.org/licenses

Please report any bugs you may encounter to: ron@ludwig.com
*/

class Config {
	public $version = '5.0.1';
	public $connections = array(
		'MySQL' => array(
			'driver'    => 'mysql',
			'dbhost'    => 'localhost',
			'dbport'    => '3306',
			'charset'   => 'utf8mb4',
			'dbuser'    => '',
			'dbpass'    => '',
			'available' => array(),
			'forbidden' => array('mysql','information_schema','performance_schema','sys'),
			'database'  => '',
			'table'     => '',
		),
		'SQLite' => array(
			'driver'    => 'sqlite',
			'dbpath'    => '../sqlite',
			'charset'   => 'utf8mb4',
			'dbuser'    => '',
			'dbpass'    => '',
			'available' => array(),
			'forbidden' => array('sqlite_sequence'),
			'database'  => '',
			'table'     => '',
		),
		/*
		'Demo' => array(
			'driver'    => 'mysql',
			'dbhost'    => 'localhost',
			'dbport'    => '3306',
			'charset'   => 'utf8mb4',
			'dbuser'    => '',
			'dbpass'    => '',
			'available' => array('demo1','demo2','demo3'),
			'forbidden' => array('mysql','information_schema','performance_schema','sys'),
			'database'  => '',
			'table'     => '',
		),
		'Trivium' => array(
			'driver'    => 'mysql',
			'dbhost'    => 'trivium.phpwebhosting.com',
			'dbport'    => '3306',
			'charset'   => 'utf8mb4',
			'dbuser'    => '',
			'dbpass'    => '',
			'available' => array(),
			'forbidden' => array('mysql','information_schema','performance_schema','sys'),
			'database'  => '',
			'table'     => '',
		),
		'Ludnet' => array(
			'driver'    => 'mysql',
			'dbhost'    => 'localhost',
			'dbport'    => '3306',
			'charset'   => 'utf8mb4',
			'dbuser'    => 'tom',
			'dbpass'    => '',
			'available' => array('demo1','demo2','demo3'),
			'forbidden' => array('mysql','information_schema','performance_schema','sys'),
			'database'  => 'ludnet2',
			'table'     => 'user',
		),
		*/
	);

	public $driver   = 'mysql';
	public $dbpath   = '../sqlite';
	public $dbhost   = '127.0.0.1';
	public $dbport   = '3306';
	public $charset  = 'utf8mb4';
	public $dbuser   = '';
	public $dbpass   = '';
	public $database = '';
	public $table    = '';

	public $column   = '';
	public $field    = '';
	public $key      = '';
	public $val      = '';

	public $status   = array();
	public $notices  = array();
	public $warnings = array();
	public $errors   = array();
	public $sqls     = array();

	public function get($var=null){
		$val = !empty($this->$var) ? $this->$var : $this;
		//foreach($this as $key => $val) {
		//	$_SESSION[$key] = $val;
		//}
		return($val);
	}
}

interface MVC {
	public function controller();
	public function model();
	public function view();
}

class DBone implements MVC {

	public $debug=0;
	public $DBO, $data;

	public function __construct(){
		date_default_timezone_set('America/Los_Angeles');
		if (!isset($_SESSION)) session_start();		$this->getRequest();
		$this->getRequest();
	}

	public function controller(){
		//$this->debug(__METHOD__, 'REQUEST', $_REQUEST,1);
		//$this->debug(__METHOD__, 'THIS', $this,1);

		//$this->connect($this->database);
		$this->model();
		$this->showHead();
		$this->showStatus();
		$this->view();
		$this->showFoot();

		//printf('<PRE>THIS = %s</PRE>'."\n", print_r($this));
		//printf('<PRE>SESSION = %s</PRE>'."\n", print_r($_SESSION));
		//exit();

	}

	public function model(){
		if (empty($this->page)) {
			if (!$this->isConnected()) {
				$this->page = 'login';
			} else if (!$this->isLoggedIn()) {
				$this->page = 'login';
			} else {
				//$this->page = 'databases';
				$this->page = 'login';
			}
		}

		switch($this->frame){
			case('head'):
				$this->showHead();
				$this->showHeader();
				$this->showFoot();
				break;
			case('body'):
				$this->body();
				break;
			case('foot'):
				$this->showHead();
				$this->showFooter();
				$this->showFoot();
				break;
			default:
				$this->view();
				break;
		}
	}

	public function view(){
		printf('<!DOCTYPE html>'."\n");
		printf('<html>'."\n");
		printf('<head>'."\n");
		printf('<title>DBone</title>'."\n");
		printf('<meta charset="utf-8">'."\n");
		printf('<meta name="author" content="Ron Ludwig">'."\n");
		printf('<meta name="description" content="DBone database manager"/>'."\n");
		printf('<meta name="keywords" content="dbone,database,mananger">'."\n");
		printf('<meta name="format-detection" content="telephone=no"/>'."\n");
		printf('<meta name="google" content="notranslate"/>'."\n");
		printf('<meta name="viewport" content="width=device-width, initial-scale=1"/>'."\n");
		printf('<meta property="og:description" content="DBone database manager"/>'."\n");
		printf('<link href="http://dbone.us/images/logo.png" rel="icon" type="image/x-icon"/>'."\n");
		printf('</head>'."\n");
		printf('<frameset frameborder="0" rows="48px,*,28px">'."\n");
		printf('<frame name="head" src="?frame=head&page=%s&database=%s&table=%s&view=%s&trigger=%s&event=%s&routine=%s&index=%s&column=%s&field=%s&key=%s&val=%s&query=%s" scrolling="no"  />'."\n", $this->page, $this->database, $this->table, $this->view, $this->trigger, $this->event, $this->routine, $this->index, $this->column, $this->field, $this->key, $this->val, $this->query);
		printf('<frame name="body" src="?frame=body&page=%s&database=%s&table=%s&view=%s&trigger=%s&event=%s&routine=%s&index=%s&column=%s&field=%s&key=%s&val=%s&query=%s" scrolling="auto"/>'."\n", $this->page, $this->database, $this->table, $this->view, $this->trigger, $this->event, $this->routine, $this->index, $this->column, $this->field, $this->key, $this->val, $this->query);
		printf('<frame name="foot" src="?frame=foot&page=%s&database=%s&table=%s&view=%s&trigger=%s&event=%s&routine=%s&index=%s&column=%s&field=%s&key=%s&val=%s&query=%s" scrolling="auto"/>'."\n", $this->page, $this->database, $this->table, $this->view, $this->trigger, $this->event, $this->routine, $this->index, $this->column, $this->field, $this->key, $this->val, $this->query);
		printf('</frameset>'."\n");
		printf('</html>'."\n");
	}

	public function showHead(){
		printf('<!DOCTYPE html>'."\n");
		printf('<html>'."\n");
		printf('<head>'."\n");
		printf('<title>DBone</title>'."\n");
		printf('<meta charset="utf-8">'."\n");
		printf('<meta name="author" content="Ron Ludwig">'."\n");
		printf('<meta name="description" content="DBone database manager"/>'."\n");
		printf('<meta name="keywords" content="dbone,database,mananger">'."\n");
		printf('<meta name="format-detection" content="telephone=no"/>'."\n");
		printf('<meta name="google" content="notranslate"/>'."\n");
		printf('<meta name="viewport" content="width=device-width, initial-scale=1"/>'."\n");
		printf('<meta property="og:description" content="DBone database manager"/>'."\n");
		printf('<link href="http://dbone.us/images/logo.png" rel="icon" type="image/x-icon"/>'."\n");

		printf('<style>'."\n");
		printf('body   {font-family:arial; margin:0px;}'."\n");
		printf('a {text-decoration:none;}'."\n");
		printf('header {background-color:#369; color:#FFF; font:normal 120%% arial;}'."\n");
		printf('header table tr th {font-size:32px;}'."\n");
		printf('header img {height:40px;}'."\n");
		printf('header input {font-size:32px; height:24px; width:90%%;}'."\n");

		printf('h1,h2,h3,h4,h5,h6 {margin: 0px;}'."\n");
		printf('h4 {background-color:#090; color:#FFF; font-face:arial; font-size:18px;}'."\n");
		printf('h5 {background-color:#F90; color:#000; font-face:arial; font-size:14px; font-weight:normal;}'."\n");
		printf('h6 {background-color:#F00; color:#FFF; font-face:arial; font-size:16px;}'."\n");

		printf('section form table {width:370px;}'."\n");
		printf('section table,tr,th,td {border-collapse:collapse; border:1px solid #FFF; white-space:nowrap;}'."\n");
		
		printf('table,tr,th,td {border-collapse:collapse; border:0px solid #369; white-space:nowrap;}'."\n");
		printf('table thead {background-color:#369; color:#FFF;}'."\n");
		printf('table thead {position:sticky; top:0; z-index:2;}'."\n");
		printf('table thead,tbody tr th:first-child {background-color: #369; width:40px;}'."\n");
		printf('table tbody tr:nth-child(even) {background-color: #DDD;}'."\n");
		printf('table tbody th {background-color:#369; color:#FFF;}'."\n");
		printf('table thead th:first-child {left:0; position:sticky; z-index:1;}'."\n");
		printf('table tbody th:first-child {left:0; position:sticky; z-index:1;}'."\n");
		printf('table tbody tr:hover {background-color: #FF0; cursor:pointer;}'."\n");
		printf('table tfoot {background-color:#369; color:#FFF;}'."\n");

		printf('form {display:inline; margin:0px;}'."\n");
		//printf('section form table tfoot tr th button {width: 50%%;}'."\n");
		printf('fieldset button {width: 98%%;}'."\n");
		printf('fieldset {width: 98%%;}'."\n");
		printf('input    {width: 97%%;}'."\n");
		printf('select   {width: 100%%;}'."\n");
		printf('textarea {width: 97%%;}'."\n");
		
		printf('footer {background-color:#369; color:#FFF; font:normal 105%% arial;}'."\n");
		printf('footer a {color:#FFF; font:normal 100%% arial; text-decoration:none;}'."\n");
		/*

		printf('menu {margin:0px; padding:0;}'."\n");
		printf('menu table {width:370px;}'."\n");
		printf('menu table thead tr th {cursor:pointer; font-size:16px; text-align:center;}'."\n");
		printf('menu table thead tr th.on {background-color:#F00; color:#FFF;}'."\n");
		printf('menu table thead tr th.off  {background-color:#CCC; color:#000;}'."\n");

		printf('table {width:100%%;}'."\n");
		
		//printf('table tfoot tr th button {width: 80px;}'."\n");

		printf('table tfoot tr th button#add    {background-color:#090; color:#FFF; width:30%%;}'."\n");
		printf('table tfoot tr th button#change {background-color:#F90; color:#FFF; width:30%%;}'."\n");
		printf('table tfoot tr th button#create {background-color:#090; color:#FFF; width:30%%;}'."\n");
		printf('table tfoot tr th button#delete {background-color:#C00; color:#FFF; width:30%%;}'."\n");
		printf('table tfoot tr th button#drop   {background-color:#F00; color:#FFF; width:30%%;}'."\n");
		printf('table tfoot tr th button#insert {background-color:#060; color:#FFF; width:30%%;}'."\n");
		printf('table tfoot tr th button#modify {background-color:#099; color:#FFF; width:30%%;}'."\n");
		printf('table tfoot tr th button#move   {background-color:#F0F; color:#FFF; width:30%%;}'."\n");
		printf('table tfoot tr th button#rename {background-color:#909; color:#FFF; width:30%%;}'."\n");
		printf('table tfoot tr th button#update {background-color:#00C; color:#FFF; width:30%%;}'."\n");
		printf('table tfoot tr th button#cancel {background-color:#99F; color:#000; width:30%%;}'."\n");
		printf('table tfoot tr th button#clear  {background-color:#F99; color:#000; width:30%%;}'."\n");
		printf('table tfoot tr th button#reset  {background-color:#9F9; color:#000; width:30%%;}'."\n");
		printf('table tfoot tr th button#create_view {background-color:#090; color:#FFF; width:300px;}'."\n");
		printf('table tfoot select {background-color:#369; color:#FFF; width:250px;}'."\n");

		printf('form table {width: 370px;}'."\n");

		printf('table tbody tr th {text-align:left; vertical-align:top}'."\n");
		//printf('table tfoot tr th button {width: 99%%;}'."\n");
		printf('code {font-face:courier; font-size:12px;}'."\n");
		*/
		printf('</style>'."\n");

		printf('<script>'."\n");
		printf('function clearInputs() {'."\n");
		printf('	var elements = document.getElementsByTagName("input");'."\n");
		printf('	for (var i=0; i < elements.length; i++) {'."\n");
		printf('		if (elements[i].type == "text") {'."\n");
		printf('			elements[i].value = "";'."\n");
		printf('		}'."\n");
		printf('	}'."\n");
		printf('	return false;'."\n");
		printf('}'."\n");
		printf('function confirmDelete() {'."\n");
		printf('	var e = document.getElementsById("table");'."\n");
		printf('	var s = e.options[e.selectedIndex].value;'."\n");
		printf('	return confirm(\'Delete selected table?\');'."\n");
		printf('	return false;'."\n");
		printf('}'."\n");
		printf('</script>'."\n");
		printf('</head>'."\n");
		printf('<body>'."\n");
		printf('<center>'."\n");
	}

	public function showHeader(){
		printf('<header>'."\n");
		//printf('<form action="?page=search" method="post" target="_parent">'."\n");
		printf('<table>'."\n");
		//printf('<thead>'."\n");
		printf('<tr>'."\n");
		if (!$this->isLoggedIn()) {
			printf('<td><a href="../" target="_parent"><img src="//ronludwig.com/dbone/images/dbone.png"></a></th>'."\n");
			printf('<th width="100%%">%s</th>'."\n", 'DBone');
			printf('<td><a href="?page=login" target="_parent"><img src="//ronludwig.com/dbone/images/login.png"></a></th>'."\n");
		} else {
			$this->page = 'databases';
			printf('<td><a href="?page=%s" target="_parent"><img src="//ronludwig.com/dbone/images/dbone.png"></a></th>'."\n", $this->page);
			printf('<th width="100%%"><input type="text" name="query" value="%s" autofocus/></th>'."\n", $this->query);
			printf('<td><a href="?page=tools" target="_parent"><img src="//ronludwig.com/dbone/images/tools.png"></a></th>'."\n");
		}
		printf('</tr>'."\n");
		//printf('</thead>'."\n");
		printf('</table>'."\n");
		//printf('</form>'."\n");
		printf('</header>'."\n");
	}

	public function showFooter(){
		printf('<footer>'."\n");
		if ($this->isLoggedIn()) {
			$driver   = !empty($_SESSION['driver'])   ? $_SESSION['driver']   : '';
			$dbpath   = !empty($_SESSION['dbpath'])   ? $_SESSION['dbpath']   : '';
			$dbhost   = !empty($_SESSION['dbhost'])   ? $_SESSION['dbhost']   : '';
			
			$page     = !empty($_REQUEST['page'])     ? $_REQUEST['page']     : '';
			$database = !empty($_REQUEST['database']) ? $_REQUEST['database'] : '';
			$table    = !empty($_REQUEST['table'])    ? $_REQUEST['table']    : '';
			$view     = !empty($_REQUEST['view'])     ? $_REQUEST['view']     : '';
			
			//printf('<form action="?page=export" method="post" target="_blank">'."\n");
			printf('<table width="100%%">'."\n");
			printf('<thead>'."\n");
			printf('<tr>'."\n");
			printf('<td width="100%%">'."\n");
			
			if ($driver == 'sqlite') {
				$dbhost = $dbpath;
			}

			$primary   = 'databases';
			$secondary = 'operations';
			$secondary = class_exists($secondary) ? $secondary : $primary;
			$page2 = $page == $primary ? $secondary : $primary;
			printf('<a href="?page=%s" target="_parent">%s</a>'."\n", $page2, $dbhost);

			if (!empty($database)) {
				$primary   = 'objects';
				$secondary = 'procedures';
				$secondary = class_exists($secondary) ? $secondary : $primary;
				$page2 = $page == $primary ? $secondary : $primary;
				printf(' &raquo; <a href="?page=%s&database=%s" target="_parent">%s</a>'."\n", $page2, $database, $database);
			}
			if (!empty($this->view)) {
				$primary   = 'records';
				$secondary = 'view';
				$secondary = class_exists($secondary) ? $secondary : $primary;
				$page2 = $page == $primary ? $secondary : $primary;
				printf(' &raquo; <a href="?page=%s&database=%s&view=%s" target="_parent">%s</a>'."\n", $page2, $database, $this->view, $this->view);
			} else if (!empty($table)) {
				$primary   = 'records';
				$secondary = 'structure';
				$secondary = class_exists($secondary) ? $secondary : $primary;
				$page2 = $page == $primary ? $secondary : $primary;
				printf(' &raquo; <a href="?page=%s&database=%s&table=%s" target="_parent">%s</a>'."\n", $page2, $database, $table, $table);
			}
			
			printf('</td>'."\n");
			
			if ($page == 'tables' || $page == 'records') {
				if (!empty($table)) {
					printf('<td>'."\n");
					printf('<form action="?frame=body&page=csv" method="post" target="body">'."\n");
					printf('<button id="command" name="command" tpe="submit" value="csv">CSV</button>'."\n");
					printf('</form>'."\n");
					printf('</td>'."\n");
				}
				if (!empty($database)) {
					printf('<td>'."\n");
					printf('<form action="?frame=body&page=export" method="post" target="body">'."\n");
					printf('<button id="command" name="command" tpe="submit" value="export">EXPORT</button>'."\n");
					printf('</form>'."\n");
					printf('</td>'."\n");
				}
			}
			printf('</tr>'."\n");
			printf('</thead>'."\n");
			printf('</table>'."\n");
		} else {
			printf('Copyright &copy; 2023 - DBone.us - All Rights Reserved'."\n");
		}
		printf('</footer>'."\n");
	}

	public function showFoot(){
		//printf('<br>'."\n");
		printf('</center>'."\n");
		//$this->sql();
		printf('</body>'."\n");
		printf('</html>'."\n");
	}

	public function showStatus(){
		$this->notice();
		$this->warning();
		$this->error();
		//$this->sql();
		$this->clearStatus();
	}
	
	public function clearStatus(){
		$_SESSION['status']   = array();
		$_SESSION['notices']  = array();
		$_SESSION['warnings'] = array();
		$_SESSION['errors']   = array();
		$_SESSION['sqls']     = array();
	}
	
	public function msg($type, $msg=null){
		if (!empty($msg)) {
			$_SESSION[$type][] = $msg;
		} else if (!empty($_SESSION[$type])) {
			$types = array('notices' => 'h4','warnings' => 'h5','errors' => 'h6');
			$msgs  = $_SESSION[$type];
			//printf('<PRE>MSGS = %s</PRE>'."\n", print_r($msgs));
			foreach($msgs as $msg){
				printf('<%s>%s</%s>'."\n", $types[$type], $msg, $types[$type]);
			}
			//$_SESSION[$type] = array();
		}
	}
	
	public function notice($msg=null){
		$this->msg('notices', $msg);
	}
	
	public function warning($msg=null){
		$this->msg('warnings', $msg);
	}
	
	public function error($msg=null){
		$this->msg('errors', $msg);
	}
	
	public function sql($sql=null){
		if (!empty($sql)) {
			$_SESSION['sqls'][] = $sql;
		} else if (!empty($_SESSION['sqls'])) {
			printf('<table bgcolor="#DDD" width="100%%"><tr><td>'."\n");
			foreach($_SESSION['sqls'] as $sql){
				printf('<code>%s</code><br>'."\n", $sql);
			}
			printf('</td></tr></table>'."\n");
			$_SESSION['sqls'] = array();
		}
	}

	public function body(){
		if (class_exists($this->page)) {
			$Page = new $this->page();
			$Page->controller();
		} else {
			$this->showHead();
			//printf('<center>'."\n");
			printf('<br><h2>Page Not Found</h2>'."\n");
			//printf('</center>'."\n");
			$this->showFoot();
		}
	}
	public function connect($database=''){
		//$this->getSession();
		
		//if ($this->isLoggedIn()){
		/*
		 $driver   = !empty($_SESSION['driver'])  ? $_SESSION['driver']  : '';
		 $dbpath   = !empty($_SESSION['dbpath'])  ? $_SESSION['dbpath']  : '';
		 $dbhost   = !empty($_SESSION['dbhost'])  ? $_SESSION['dbhost']  : '';
		 $dbport   = !empty($_SESSION['dbport'])  ? $_SESSION['dbport']  : '';
		 $charset  = !empty($_SESSION['charset']) ? $_SESSION['charset'] : '';
		 $dbuser   = !empty($_SESSION['dbuser'])  ? $_SESSION['dbuser']  : '';
		 $dbpass   = !empty($_SESSION['dbpass'])  ? $_SESSION['dbpass']  : '';
		 */
		
		$this->DBO = new DBO();
		
		//printf('<PRE>CONNECT DRIVER = %s</PRE>'."\n", $driver);
		//printf('<PRE>CONNECT DATABASE = %s</PRE>'."\n", $database);
		//printf('<PRE>CONNECT DBPATH = %s</PRE>'."\n", $dbpath);
		
		if ($this->driver == 'sqlite') {
			//printf('<PRE>DATABASE = %s</PRE>'."\n", $database);
			if (!empty($database)) {
				$dbhost = $this->dbpath;
				//printf('<PRE>TRY CONNECTING TO = %s</PRE>'."\n", $database);
				$status = $this->DBO->connect($this->driver, $dbhost, $this->dbport, $this->charset, $this->dbuser, $this->dbpass, $database);
				//printf('<PRE>CONNECT STATUS = %s</PRE>'."\n", $status);
			} else {
				if (is_dir($this->dbpath)) {
					//printf('<PRE>CONNECT DBPATH TRUE = %s</PRE>'."\n", $this->dbpath);
					$status = true;
				} else {
					$status = false;
				}
			}
		} else {
			$status = $this->DBO->connect($this->driver, $this->dbhost, $this->dbport, $this->charset, $this->dbuser, $this->dbpass, $database);
			//printf('<PRE>CONNECT STATUS2 = %s</PRE>'."\n", $status);
		}
		
		if ($status !== true) {
			//printf('<PRE>CONNECT ERROR: DATABASE FAILED TO CONNECT!</PRE>'."\n");
		} else {
			//printf('<PRE>CONNECTED TO DATABASE = %s</PRE>'."\n", $database);
		}
		return($status);
	}
	
	public function getConnection(){
		$this->data['driver']   = !empty($_SESSION['driver'])   ? $_SESSION['driver']   : 'mysql';
		$this->data['dbhost']   = !empty($_SESSION['dbhost'])   ? $_SESSION['dbhost']   : 'localhost';
		$this->data['dbport']   = !empty($_SESSION['dbport'])   ? $_SESSION['dbport']   : '3306';
		$this->data['charset']  = !empty($_SESSION['charset'])  ? $_SESSION['charset']  : 'utf8mb4';
		$this->data['dbuser']   = !empty($_SESSION['dbuser'])   ? $_SESSION['dbuser']   : '';
		$this->data['dbpass']   = !empty($_SESSION['dbpass'])   ? $_SESSION['dbpass']   : '';
		$this->data['database'] = !empty($_SESSION['database']) ? $_SESSION['database'] : '';
		$this->data['table']    = !empty($_SESSION['table'])    ? $_SESSION['table']    : '';
		$this->data['view']     = !empty($_SESSION['view'])     ? $_SESSION['view']     : '';
		return($data);
	}
	
	public function setConnection($name){
		$connection = $_SESSION['connections'][$name];
		//printf('<PRE>CONNECTION = %s</PRE>'."\n", print_r($connection));
		foreach($connection as $key => $val){
			$_SESSION[$key] = $val;
		}
		//printf('<PRE>SESSION = %s</PRE>'."\n", print_r($_SESSION));exit();
		return(true);
	}

	public function getDrivers() {
		$possible_drivers = array (
				'mysql',
				'sqlite',
				'cubrid',
				'firebird',
				'ibm',
				'informix',
				'mssql',
				'oci',
				'oci8',
				'odbc',
				'pqsql',
				'snowflake',
				'4d',
		);
		$available_drivers = \PDO::getAvailableDrivers();
		foreach($possible_drivers as $driver) {
			$drivers[$driver] = in_array($driver, $available_drivers) ? 1 : 0;
		}
		//printf('<hr><PRE>DRIVERS = %s</PRE><hr>'."\n", print_r($drivers));
		return $drivers;
	}

	public function getDatabases(){
		$databases = array();
		//$this->getSession();
		/*
		 $driver    = !empty($_SESSION['driver'])    ? $_SESSION['driver']    : '';
		 $dbpath    = !empty($_SESSION['dbpath'])    ? $_SESSION['dbpath']    : '';
		 $available = !empty($_SESSION['available']) ? $_SESSION['available'] : array();
		 $forbidden = !empty($_SESSION['forbidden']) ? $_SESSION['forbidden'] : array();
		 */
		
		
		if ($this->driver == 'sqlite') {
			$files = scandir($this->dbpath);
			//printf('<PRE>FILES = %s</PRE>'."\n", print_r($files));
			$databases = array();
			foreach($files as $file) {
				if (strpos($file, '.') == 0) continue;
				$database = substr($file, 0, strrpos($file, "."));
				if (in_array($database, $this->forbidden)) continue;
				$databases[] = $database;
			}
		} else {
			if (!empty($this->available)) {
				foreach($this->available as $database) {
					$databases[]['Database'] = $database;
				}
				$this->data = $databases;
			} else {
				
				$this->connect();
				
				$sql = "SHOW DATABASES;";
				$this->debug(__METHOD__, 'sql', $sql);
				$data = $this->DBO->query($sql);
				$this->debug(__METHOD__, 'data', $data);
			}
			$databases = array();
			foreach($data as $rec) {
				$database = $rec['Database'];
				if (empty($this->forbidden) || !in_array($database, $this->forbidden)) {
					$databases[] = $database;
				}
			}
		}
		$this->debug(__METHOD__, 'databases', $databases);
		return($databases);
	}

	public function getData($database, $table){
		$fields = array();
		$this->connect($database);
		$sql = "SELECT * FROM `$table`";
		$this->sql($sql);
		$recs = $this->DBO->query($sql);
		$recs = !empty($recs) ? $recs : array();
		//printf('<PRE>RECS = %s</PRE>'."\n", print_r($recs));exit;
		return($recs);
	}

	public function getFields($database, $table){
		$fields = array();
		$this->connect($database);
		$sql = "SELECT * FROM `$table` LIMIT 1";
		$this->sql($sql);
		$recs = $this->DBO->query($sql);
		$field = array();
		foreach($recs[0] as $key => $val){
			$fields[] = $key;
		}
		return($fields);
	}

	public function getColumns($database, $table){
		if ($this->driver == 'sqlite') {
			$sql = "PRAGMA table_info(`$this->table`);";
			$this->sql($sql);
			$this->debug(__METHOD__, 'sql', $sql);
			$data = $this->DBO->query($sql);
			$this->debug(__METHOD__, 'data', $data);
			$columns = array();
			//if (!empty($data) || count($data) != 0) {
			if (is_string($data)) return($data);
			$columns = array();
			foreach($data as $rec) {
				$column = array();
				$column['column']   = $rec['name'];
				$column['type']     = $rec['type'];
				$column['key']      = $rec['pk'] == '1' ? 'PRI' : '';
				$column['null']     = $rec['notnull'] == '0' ? 'Yes' : 'No';
				$columns[] = $column;
			}
		} else if ($this->driver == 'mysql') {
			//$sql = "SHOW COLUMNS FROM `$this->table`";
			$sql = "SELECT * FROM information_schema.columns WHERE table_schema = '$this->database' and table_name = '$this->table'";
			$this->debug(__METHOD__, 'sql', $sql);
			$this->sql($sql);
			$data = $this->DBO->query($sql);
			$this->debug(__METHOD__, 'data', $data);
			$columns = array();
			//if (!empty($data) || count($data) != 0) {
			if (is_string($data)) return($data);
			$columns = array();
			foreach($data as $rec) {
				$column = array();
				$column['column']   = $rec['COLUMN_NAME'];
				$column['type']  = $rec['COLUMN_TYPE'];
				$types = explode(' ', trim($column['type']));
				$column['type'] = $types[0];

				//$column['type']    .= !empty($rec['NUMERIC_PRECISION']) ? '('.$rec['NUMERIC_PRECISION'].')' : '';

				$column['key']      = $rec['COLUMN_KEY'];
				$column['extra']    = $rec['EXTRA'];
				$column['extra'] = str_replace('auto_increment', 'AI', $column['extra']);
				$column['extra'] = str_replace('DEFAULT_GENERATED', 'DG', $column['extra']);
				$column['null']     = $rec['IS_NULLABLE'] == 'NO' ? 'No' : 'Yes';
				$columns[] = $column;
			}
		} else {
			
			
			
		}
		return($columns);
	}

	public function getColumn($database, $table, $column){
		if ($this->driver == 'sqlite') {
			$sql = "PRAGMA table_info(`$this->table`);";
			$this->sql($sql);
			$this->debug(__METHOD__, 'sql', $sql);
			$data = $this->DBO->query($sql);
			$this->debug(__METHOD__, 'data', $data);
			$columns = array();
			//if (!empty($data) || count($data) != 0) {
			if (is_string($data)) return($data);
			foreach($data as $rec) {
				$col = array();
				$col['column']  = $rec['name'];
				$col['type']    = $rec['type'];
				$col['key']     = $rec['pk'] == '1' ? 'PRI' : '';
				$col['null']    = $rec['notnull'] == '0' ? 'Yes' : 'No';
				$col['default'] = $rec['dflt_value'];
				if ($col['column'] == $column) {
					$column = $col;
					break;
				}
			}
		} else {
			//$sql = "SHOW COLUMNS FROM `$this->table`";
			//$sql = "SELECT * FROM information_schema.columns WHERE table_schema = '$this->database' and table_name = '$this->table'";
			$sql = "SELECT * FROM information_schema.columns WHERE `TABLE_SCHEMA` = '$database' AND `TABLE_NAME` = '$table' AND `COLUMN_NAME` = '$column';";
			$this->debug(__METHOD__, 'sql', $sql);
			$data = $this->DBO->query($sql);
			$this->debug(__METHOD__, 'data', $data);
			if (is_string($data)) return($data);
			$rec = $data[0];
			$column = array();
			$column['column']    = $rec['COLUMN_NAME'];

			$column['type']  = $rec['COLUMN_TYPE'];
			$types = explode(' ', trim($column['type']));
			$column['type'] = $types[0];

			$column['key']       = $rec['COLUMN_KEY'];
			
			$column['attr'] = $rec['COLUMN_TYPE'];
			
			$attrs = explode(' ', trim($column['attr']));
			$column['attr'] = !empty($types[1]) ? $types[1] : '';

			$column['null']      = $rec['IS_NULLABLE'] == 'NO' ? 'No' : 'Yes';
			$column['default']   = $rec['COLUMN_DEFAULT'];
			$column['extra']     = $rec['EXTRA'];
			$column['collation'] = $rec['COLLATION_NAME'];
			$column['charset']   = $rec['CHARACTER_SET_NAME'];
			$column['comment']   = $rec['COLUMN_COMMENT'];
		}
		return($column);
	}

	public function getIndexes($database, $table){
		if ($this->driver == 'sqlite') {

			$sql = "SELECT * FROM sqlite_master WHERE type = 'index' AND tbl_name = '$table'";
			$this->debug(__METHOD__, 'sql', $sql);

			$data = $this->DBO->query($sql);
			$this->debug(__METHOD__, 'data', $data);

			$indexes = array();
			foreach($data as $rec) {
				$index = array();
				$index['column']  = $rec['name'];
				//$index['table'] = $rec['tbl_name'];
				$index['sql']    = $rec['sql'];
				$indexes[] = $index;
			}
		} else {
			$sql = "SHOW INDEXES FROM `$table`";
			$this->debug(__METHOD__, 'sql', $sql);
			//$this->sql($sql);
			$data = $this->DBO->query($sql);
			$this->debug(__METHOD__, 'data', $data);
			if (is_string($data)) return($data);
			$indexes = array();
			foreach($data as $rec) {
				$index = array();
				$index['index']   = $rec['Key_name'];
				$index['column']  = $rec['Column_name'];
				//$index['table'] = $rec['Table'];
				$index['type']    = $rec['Index_type'];
				$index['uniq']    = $rec['Non_unique'] == '0' ? 'Yes' : 'No';
				//$index['packed']  = !empty($rec['Packed']) ? 'Yes' : 'No';
				//$index['card']    = $rec['Cardinality'];
				//$index['coll']    = $rec['Collation'];
				$index['null']    = !empty($rec['Null']) ? 'Yes' : 'No';
				//$index['visible'] = $rec['Visible'] == 'YES' ? 'Yes' : 'No';
				//$index['comment'] = $rec['Comment'];
				$indexes[] = $index;
			}
		}
		return($indexes);
	}

	public function getIndex($database, $table, $column){
		$this->debug(__METHOD__, 'database', $database);
		$this->debug(__METHOD__, 'table', $table);
		$this->debug(__METHOD__, 'column', $column);

		if ($this->driver == 'sqlite') {
			$sql = "SELECT * FROM sqlite_master WHERE type = 'index' AND tbl_name = '$table'";
			$this->debug(__METHOD__, 'sql', $sql);
			
			$data = $this->DBO->query($sql);
			$this->debug(__METHOD__, 'data', $data);
			
			$index = array();
			foreach($data as $rec){
				if ($rec['name'] == $column) {
					$index = array();
					$index['index'] = $rec['name'];
					$index['sql']   = $rec['sql'];
					break;
				}
			}
		} else {
			$sql = "SHOW INDEXES FROM `$table`";
			$this->debug(__METHOD__, 'sql', $sql);
			
			$data = $this->DBO->query($sql);
			$this->debug(__METHOD__, 'data', $data);
			
			$index = array();
			foreach($data as $rec){
				if ($rec['Key_name'] == $column) {
					$index = array();
					$index['index']   = $rec['Key_name'];
					$index['column']  = $rec['Column_name'];
					//$index['table'] = $rec['Table'];
					$index['type']    = $rec['Index_type'];
					$index['uniq']    = $rec['Non_unique'] == '0' ? 'Yes' : 'No';
					$index['packed']  = !empty($rec['Packed']) ? 'Yes' : 'No';
					$index['card']    = $rec['Cardinality'];
					$index['coll']    = $rec['Collation'];
					$index['null']    = !empty($rec['Null']) ? 'Yes' : 'No';
					//$index['visible'] = $rec['Visible'] == 'YES' ? 'Yes' : 'No';
					$index['comment'] = $rec['Comment'];
					break;
				}
			}
		}
		$this->debug(__METHOD__, 'index', $index);
		return($index);
	}

	public function getConnections(){
		$Config = new Config();
		$connections = $Config->get('connections');
		$this->debug(__METHOD__, 'connections', $connections);
		return($connections);
	}
	
	public function getRequest(){
		//$this->driver    = !empty($_REQUEST['driver'])    ? $_REQUEST['driver']    : $_SESSION['driver'];
		//$this->dbhost    = !empty($_REQUEST['dbhost'])    ? $_REQUEST['dbhost']    : $_SESSION['dbhost'];
		//$this->dbport    = !empty($_REQUEST['dbport'])    ? $_REQUEST['dbport']    : $_SESSION['dbport'];
		//$this->charset   = !empty($_REQUEST['charset'])   ? $_REQUEST['charset']   : $_SESSION['charset'];
		//$this->dbuser    = !empty($_REQUEST['dbuser'])    ? $_REQUEST['dbuser']    : $_SESSION['dbuser'];
		//$this->dbpass    = !empty($_REQUEST['dbpass'])    ? $_REQUEST['dbpass']    : $_SESSION['dbpass'];

		$driver    = !empty($_SESSION['driver'])    ? $_SESSION['driver']    : '';
		$dbpath    = !empty($_SESSION['dbpath'])    ? $_SESSION['dbpath']    : '';
		$dbhost    = !empty($_SESSION['dbhost'])    ? $_SESSION['dbhost']    : '';
		$dbport    = !empty($_SESSION['dbport'])    ? $_SESSION['dbport']    : '';
		$charset   = !empty($_SESSION['charset'])   ? $_SESSION['charset']   : '';
		$dbuser    = !empty($_SESSION['dbuser'])    ? $_SESSION['dbuser']    : '';
		$dbpass    = !empty($_SESSION['dbpass'])    ? $_SESSION['dbpass']    : '';
		$available = !empty($_SESSION['available']) ? $_SESSION['available'] : '';
		$forbidden = !empty($_SESSION['forbidden']) ? $_SESSION['forbidden'] : '';
		
		$this->driver    = !empty($_REQUEST['driver'])    ? $_REQUEST['driver']    : $driver;
		$this->dbpath    = !empty($_REQUEST['dbpath'])    ? $_REQUEST['dbpath']    : $dbpath;
		$this->dbhost    = !empty($_REQUEST['dbhost'])    ? $_REQUEST['dbhost']    : $dbhost;
		$this->dbport    = !empty($_REQUEST['dbport'])    ? $_REQUEST['dbport']    : $dbport;
		$this->charset   = !empty($_REQUEST['charset'])   ? $_REQUEST['charset']   : $charset;
		$this->dbuser    = !empty($_REQUEST['dbuser'])    ? $_REQUEST['dbuser']    : $dbuser;
		$this->dbpass    = !empty($_REQUEST['dbpass'])    ? $_REQUEST['dbpass']    : $dbpass;
		$this->available = !empty($_REQUEST['available']) ? $_REQUEST['available'] : $available;
		$this->forbidden = !empty($_REQUEST['forbidden']) ? $_REQUEST['forbidden'] : $forbidden;
		
		$this->frame     = !empty($_REQUEST['frame'])     ? $_REQUEST['frame']     : '';
		$this->page      = !empty($_REQUEST['page'])      ? $_REQUEST['page']      : '';
		$this->query     = !empty($_REQUEST['query'])     ? $_REQUEST['query']     : '';
		$this->command   = !empty($_REQUEST['command'])   ? $_REQUEST['command']   : '';
		$this->cmd       = !empty($_REQUEST['cmd'])       ? $_REQUEST['cmd']       : '';
		$this->sql       = !empty($_REQUEST['sql'])       ? $_REQUEST['sql']       : '';
		$this->connection= !empty($_REQUEST['connection'])? $_REQUEST['connection']: '';
		$this->database  = !empty($_REQUEST['database'])  ? $_REQUEST['database']  : '';
		$this->database2 = !empty($_REQUEST['database2']) ? $_REQUEST['database2'] : '';
		$this->table     = !empty($_REQUEST['table'])     ? $_REQUEST['table']     : '';
		$this->table2    = !empty($_REQUEST['table2'])    ? $_REQUEST['table2']    : '';
		$this->view      = !empty($_REQUEST['view'])      ? $_REQUEST['view']      : '';
		$this->view1     = !empty($_REQUEST['view1'])     ? $_REQUEST['view1']     : '';
		$this->view2     = !empty($_REQUEST['view2'])     ? $_REQUEST['view2']     : '';
		$this->column    = !empty($_REQUEST['column'])    ? $_REQUEST['column']    : '';
		$this->column1   = !empty($_REQUEST['column1'])   ? $_REQUEST['column1']   : '';
		$this->column2   = !empty($_REQUEST['column2'])   ? $_REQUEST['column2']   : '';
		$this->columns   = !empty($_REQUEST['columns'])   ? $_REQUEST['columns']   : '';
		$this->columns2  = !empty($_REQUEST['columns2'])  ? $_REQUEST['columns2']  : '';
		$this->record    = !empty($_REQUEST['record'])    ? $_REQUEST['record']    : '';
		$this->record1   = !empty($_REQUEST['record1'])   ? $_REQUEST['record1']   : '';
		$this->record2   = !empty($_REQUEST['record2'])   ? $_REQUEST['record2']   : '';
		$this->index     = !empty($_REQUEST['index'])     ? $_REQUEST['index']     : '';
		$this->index2    = !empty($_REQUEST['index2'])    ? $_REQUEST['index2']    : '';
		$this->field     = !empty($_REQUEST['field'])     ? $_REQUEST['field']     : '';
		$this->field2    = !empty($_REQUEST['field2'])    ? $_REQUEST['field2']    : '';
		$this->order     = !empty($_REQUEST['order'])     ? $_REQUEST['order']     : '';
		$this->where     = !empty($_REQUEST['where'])     ? $_REQUEST['where']     : '';
		$this->key       = !empty($_REQUEST['key'])       ? $_REQUEST['key']       : '';
		$this->val       = !empty($_REQUEST['val'])       ? $_REQUEST['val']       : '';
		$this->trigger   = !empty($_REQUEST['trigger'])   ? $_REQUEST['trigger']   : '';
		$this->event     = !empty($_REQUEST['event'])     ? $_REQUEST['event']     : '';
		$this->routine   = !empty($_REQUEST['routine'])   ? $_REQUEST['routine']   : '';
		
		//$_SESSION['database'] = !empty($_REQUEST['database']) ? $_REQUEST['database'] : '';
		//$_SESSION['table']    = !empty($_REQUEST['table'])    ? $_REQUEST['table']    : '';
		//$_SESSION['view']     = !empty($_REQUEST['view'])     ? $_REQUEST['view']     : '';
		//$_SESSION['field']    = !empty($_REQUEST['field'])    ? $_REQUEST['field']    : '';
	}

	public function getResults($sql, $database=null){
		$results = array();
		//printf('<PRE>getResults.database = %s</PRE>'."\n", print_r($database));exit;
		if (!empty($database)) {
			$this->connect($database);
		} else {
			$this->connect();
		}
		$this->debug(__METHOD__, 'sql', $sql);
		$results = $this->DBO->query($sql);
		$this->debug(__METHOD__, 'results', $results);
		return($results);
	}

	public function getSession(){
		$this->driver    = !empty($_SESSION['driver'])    ? $_SESSION['driver']    : '';
		$this->dbpath    = !empty($_SESSION['dbpath'])    ? $_SESSION['dbpath']    : '';
		$this->dbhost    = !empty($_SESSION['dbhost'])    ? $_SESSION['dbhost']    : '';
		$this->dbport    = !empty($_SESSION['dbport'])    ? $_SESSION['dbport']    : '';
		$this->charset   = !empty($_SESSION['charset'])   ? $_SESSION['charset']   : '';
		$this->dbuser    = !empty($_SESSION['dbuser'])    ? $_SESSION['dbuser']    : '';
		$this->dbpass    = !empty($_SESSION['dbpass'])    ? $_SESSION['dbpass']    : '';
		//$this->database  = !empty($_SESSION['database'])  ? $_SESSION['database']  : '';
		$this->available = !empty($_SESSION['available']) ? $_SESSION['available'] : array();
		$this->forbidden = !empty($_SESSION['forbidden']) ? $_SESSION['forbidden'] : array();
	}
	
	public function getStatus($results, $notice, $page, $database=null, $table=null){
		
		/*
		 printf('<PRE>RESULTS  = %s</PRE>'."\n",print_r($results));
		 printf('<PRE>NOTICE   = %s</PRE>'."\n",print_r($notice));
		 printf('<PRE>PAGE     = %s</PRE>'."\n",print_r($page));
		 printf('<PRE>DATABASE = %s</PRE>'."\n",print_r($database));
		 printf('<PRE>TABLE    = %s</PRE>'."\n",print_r($table));
		 */
		
		if (!is_string($results)) {
			$this->notice($notice);
			
			//printf('<PRE>SESSION1 = %s</PRE>'."\n", print_r($_SESSION));
			//exit;
			
			$this->redirect($page, $database, $table);
			return(true);
		} else {
			$this->error($results);
		}
		return(false);
	}

	public function getRows($driver, $database, $table){
		//if ($driver == 'sqlite') {
			
			
		//} else {
			$sql = "SELECT COUNT(*) AS `count` FROM `$table`";
			$this->debug(__METHOD__, 'sql', $sql);
			//printf('<PRE>SQL = %s</PRE>'."\n",print_r($sql));
			$count = $this->DBO->query($sql);
			//printf('<PRE>COUNT = %s</PRE>'."\n",print_r($count));
			$this->debug(__METHOD__, 'count', $count);
			$rows = !empty($count[0]['count']) ? $count[0]['count'] : 0;
			$this->debug(__METHOD__, 'rows', $rows);
		//}
		return($rows);
	}

	public function getTables($driver, $database){
		$this->debug(__METHOD__, 'driver', $driver);
		$this->debug(__METHOD__, 'database', $database);

		if ($driver == 'sqlite') {
			$sql = "SELECT * FROM sqlite_master WHERE `type` = 'table' AND name NOT LIKE 'sqlite_%'";
			$this->sql($sql);
			//printf('<PRE>SQL = %s</PRE>'."\n",print_r($sql));
			$recs = $this->DBO->query($sql);
			//printf('<PRE>RECS = %s</PRE>'."\n",print_r($recs));
			$tables = array();
			foreach($recs as $rec) {
				if ($rec['name'] == 'sqlite_sequence') continue;
				$table = array();
				$table['table'] = $rec['name'];
				$table['sql']   = $rec['sql'];
				$tables[] = $table;
			}
		} else {
			//$sql = "SHOW TABLES FROM `$database`";
			$sql = "SELECT * FROM information_schema.tables";
			$sql.= " WHERE TABLE_TYPE = 'BASE TABLE'";
			if (!empty($database)) {
				$sql.= " AND TABLE_SCHEMA = '$database';";
			}

			$this->debug(__METHOD__, 'sql', $sql);
			$data = $this->DBO->query($sql);
			$this->debug(__METHOD__, 'data', $data);

			$tables = array();
			foreach($data as $rec){
				$table = array();
				$table['table']     = $rec['TABLE_NAME'];
				$table['database']  = $rec['TABLE_SCHEMA'];
				$table['created']   = $rec['CREATE_TIME'];
				$table['engine']    = $rec['ENGINE'];
				$table['collation'] = $rec['TABLE_COLLATION'];
				$table['auto_increment'] = $rec['AUTO_INCREMENT'];
				$table['comment']  = $rec['TABLE_COMMENT'];
				$tables[] = $table;
			}
		}
		$this->debug(__METHOD__, 'tables', $tables);
		return($tables);
	}

	public function getTriggers($driver, $database){
		$this->debug(__METHOD__, 'driver', $driver);
		$this->debug(__METHOD__, 'database', $database);
		$sql = "SHOW TRIGGERS FROM `$database`";
		$this->debug(__METHOD__, 'sql', $sql);
		$data = $this->DBO->query($sql);
		$this->debug(__METHOD__, 'data', $data);
		return($data);
	}

	public function getTrigger($driver, $database, $trigger){
		$this->debug(__METHOD__, 'driver', $driver);
		$this->debug(__METHOD__, 'database', $database);
		//$sql = "SHOW TRIGGERS FROM `$database`";
		$sql = "SHOW TRIGGERS FROM `$database` WHERE `Trigger` = '$trigger'";
		$this->debug(__METHOD__, 'sql', $sql);
		$data = $this->DBO->query($sql);
		$this->debug(__METHOD__, 'data', $data);
		return($data);
	}
	
	public function getEvent($driver, $database, $event){
		$this->debug(__METHOD__, 'driver', $driver);
		$this->debug(__METHOD__, 'database', $database);
		$this->debug(__METHOD__, 'event', $event);
		//$sql = "SHOW EVENTS";
		//$sql = "SHOW EVENTS FROM `$database`";
		$sql = "SHOW EVENTS FROM `$database` WHERE `Name` = '$event'";
		$this->debug(__METHOD__, 'sql', $sql);
		$data = $this->DBO->query($sql);
		$this->debug(__METHOD__, 'data', $data);
		return($data);
	}
	
	public function getRoutine($driver, $database, $routine){
		$this->debug(__METHOD__, 'driver', $driver);
		$this->debug(__METHOD__, 'database', $database);
		$this->debug(__METHOD__, 'routine', $routine);
		$sql = "SHOW PROCEDURE STATUS WHERE Db = '$database' AND Name = '$routine';";
		$this->debug(__METHOD__, 'sql', $sql);
		$data = $this->DBO->query($sql);
		$this->debug(__METHOD__, 'data', $data);
		return($data);
	}
	
	public function getView($driver, $database, $view){
		$this->debug(__METHOD__, 'driver', $driver);
		$this->debug(__METHOD__, 'database', $database);
		$this->debug(__METHOD__, 'view', $view);

		if ($driver == 'sqlite') {
			//$sql = "SELECT * FROM sqlite_master WHERE `type` = 'view' AND name NOT LIKE 'sqlite_%'";
			$sql = "SELECT * FROM sqlite_master WHERE `type` = 'view'";
			$this->debug(__METHOD__, 'sql', $sql);
			$data = $this->DBO->query($sql);
			$this->debug(__METHOD__, 'data', $data);
			$record = array();
			foreach($data as $rec) {
				//if ($rec['name'] == 'sqlite_sequence') continue;
				$record['view'] = $rec['name'];
				$record['sql']  = $rec['sql'];
			}
		} else {
			/*
			$sql = "SELECT * FROM information_schema.views"; 
			$sql.= " WHERE TABLE_SCHEMA = '$database'";
			$sql.= " AND TABLE_NAME = '$view'";
			*/

			$sql = "SHOW CREATE TABLE `$database`.`$view`";
			$this->debug(__METHOD__, 'sql', $sql);
			$data = $this->DBO->query($sql);
			$this->debug(__METHOD__, 'data', $data);

			$rec = $data[0];
			$record = array();
			$record['view'] = $rec['View'];
			$record['sql']  = $rec['Create View'];
		}
		$this->debug(__METHOD__, 'record', $record);
		return($record);
	}

	public function getViews($driver, $database){
		$this->debug(__METHOD__, 'driver', $driver);
		$this->debug(__METHOD__, 'database', $database);

		if ($driver == 'sqlite') {
			$sql = "SELECT * FROM sqlite_master WHERE `type` = 'view'";
			$this->sql($sql);
			$this->debug(__METHOD__, 'sql', $sql);
			$data = $this->DBO->query($sql);
			$this->debug(__METHOD__, 'data', $data);
			$views = array();
			foreach($data as $rec){
				if ($rec['name'] == 'sqlite_sequence') continue;
				$view = array();
				$view['view'] = $rec['name'];
				$view['sql']  = $rec['sql'];
				$views[] = $view;
			}
		} else {
			//$sql = "SHOW FULL TABLES WHERE Table_Type LIKE 'VIEW';";
			$sql = "SELECT * FROM information_schema.tables";
			$sql.= " WHERE TABLE_TYPE = 'VIEW'";
			$sql.= " AND TABLE_SCHEMA != 'sys'";
			if (!empty($database)) {
				$sql.= " AND TABLE_SCHEMA = '$database'";
			}
			$sql.= " ORDER BY TABLE_NAME ASC";
			$this->debug(__METHOD__, 'sql', $sql);
			$data = $this->DBO->query($sql);
			$this->debug(__METHOD__, 'data', $data);
			$views = array();
			foreach($data as $rec){
				$view = array();
				$view['view']     = $rec['TABLE_NAME'];
				//$view['database'] = $rec['TABLE_SCHEMA'];
				$view['created']  = $rec['CREATE_TIME'];
				$view['comment']  = $rec['TABLE_COMMENT'];
				$views[] = $view;
			}
		}
		$this->debug(__METHOD__, 'views', $views);
		return($views);
	}

	public function getRoutines($driver, $database){
		$this->debug(__METHOD__, 'driver', $driver);
		$this->debug(__METHOD__, 'database', $database);
		//$sql = "SHOW PROCEDURE STATUS FROM `$database`";
		$sql = "SHOW PROCEDURE STATUS WHERE Db = '$database';";
		$this->debug(__METHOD__, 'sql', $sql);
		$data = $this->DBO->query($sql);
		$this->debug(__METHOD__, 'data', $data);
		return($data);
	}

	public function createDatabase($database){
		$this->connect();
		$sql = sprintf("CREATE DATABASE `%s`;", $database);
		$this->sql($sql);
		$status = $this->DBO->exec($sql);
		return($status);
	}
	
	public function copyDatabase($database, $database2){
		$tables = $this->getTables($database);
		foreach($tables as $table){
			$sql = sprintf("CREATE TABLE %s.%s AS SELECT * FROM %s.%s;", $database2, $table, $database, $table);
			$this->sql($sql);
			$status = $this->DBO->exec($sql);
		}
		return(true);
	}
	
	public function cloneDatabase($database, $database2){
		$tables = $this->getTables($database);
		foreach($tables as $table){
			$sql = sprintf("CREATE TABLE %s.%s LIKE %s.%s;", $database2, $table, $database, $table);
			$this->sql($sql);
			$status = $this->DBO->exec($sql);
		}
		return(true);
	}
	
	public function deleteDatabase($database){
		$sql = sprintf("DROP DATABASE `%s`;", $database);
		$this->sql($sql);
		$status = $this->DBO->exec($sql);
		return($status);
	}
	
	public function renameDatabase($database, $database2){
		$sql = sprintf("CREATE DATABASE `%s`;", $database2);
		$this->sql($sql);
		$status = $this->DBO->exec($sql);
		$sql = sprintf("SHOW DATABASES LIKE '%s';", $database2);
		//$this->sql($sql);
		$data = $this->DBO->query($sql);
		if (!count($data)) {
			$status = "Failed to create new database!";
			//$this->error($status);
			return($status);
		}
		$tables = $this->getTables($database);
		foreach($tables as $table){
			$sql = sprintf("RENAME TABLE %s.%s TO %s.%s;", $database, $table, $database2, $table);
			$this->sql($sql);
			$status = $this->DBO->exec($sql);
			if (is_string($status)) {
				return($status);
			}
		}
		$sql = sprintf("DROP DATABASE `%s`;", $database);
		$this->sql($sql);
		$status = $this->DBO->exec($sql);
		return($status);
	}

	public function getEvents($driver, $database){
		$this->debug(__METHOD__, 'driver', $driver);
		$this->debug(__METHOD__, 'database', $database);
		//$sql = "SHOW EVENTS FROM `$database`";
		$sql = "SHOW EVENTS";
		$this->debug(__METHOD__, 'sql', $sql);
		$data = $this->DBO->query($sql);
		$this->debug(__METHOD__, 'data', $data);
		return($data);
	}

	/*
	CREATE EVENT IF NOT EXISTS test_event_01
	ON SCHEDULE AT CURRENT_TIMESTAMP 
	DO
		INSERT INTO messages(message,created)
		VALUES('Test MySQL Event 1',NOW());
	*/

	public function createEvent($driver, $database, $event){
		$this->debug(__METHOD__, 'driver', $driver);
		$this->debug(__METHOD__, 'database', $database);
		$this->debug(__METHOD__, 'event', $event);
		if ($this->driver == 'sqlite'){
			//$sql = sprintf("CREATE INDEX `%s` ON %s (`%s`);", $index, $table, $column);
		} else {
			$sql = sprintf("CREATE EVENT `%s` ON SCHEDULE AT '%s' DO %s;", $event['name'], $event['starts'], $event['definition']);
		}
		$this->debug(__METHOD__, 'sql', $sql);
		$status = $this->DBO->exec($sql);
		$this->debug(__METHOD__, 'status', $status);
		return($status);
	}

	public function deleteEvent($database, $event){
		$sql = sprintf("DROP EVENT `%s`;", $event['name']);
		$this->debug(__METHOD__, 'sql', $sql);
		$status = $this->DBO->exec($sql);
		return($status);
	}

	public function renameEvent($database, $event1, $event2){
		$status = $this->createEvent($database, $event2);
		if (is_string($status)) return($status);
		$status = $this->deleteEvent($database, $event1);
		return($status);
	}

	public function createTable($table){
		$sql = sprintf("CREATE TABLE `%s` (`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY,`name` VARCHAR(80) NOT NULL,`date` DATE);", $table);
		$this->sql($sql);
		$status = $this->DBO->exec($sql);
		return($status);
	}
	
	public function copyTable($table, $table2){
		$sql = sprintf("CREATE TABLE `%s` AS SELECT * FROM `%s`;", $table2, $table);
		$this->sql($sql);
		$status = $this->DBO->exec($sql);
		return(true);
	}
	
	public function cloneTable($table, $table2){
		$sql = sprintf("CREATE TABLE `%s` LIKE `%s`;", $table2, $table);
		$this->sql($sql);
		$status = $this->DBO->exec($sql);
		return(true);
	}
	
	public function deleteTable($table){
		$sql = sprintf("DROP TABLE `%s`;", $table);
		$this->sql($sql);
		$status = $this->DBO->exec($sql);
		return($status);
	}

	public function renameTable($table, $table2){
		$sql = sprintf("RENAME TABLE `%s` TO `%s`;", $table, $table2);
		$this->sql($sql);
		$status = $this->DBO->exec($sql);
		return($status);
	}

	//CREATE TRIGGER `before_employee_update` BEFORE UPDATE ON `employees` FOR EACH ROW INSERT INTO 
	public function createTrigger($database, $trigger){
		$this->debug(__METHOD__, 'database', $database);
		$this->debug(__METHOD__, 'trigger', $trigger);
		if ($this->driver == 'sqlite'){
			//$sql = sprintf("CREATE INDEX `%s` ON %s (`%s`);", $index, $table, $column);
		} else {
			$sql = sprintf("CREATE TRIGGER `%s` %s %s ON `%s` FOR EACH ROW %s;", $trigger['name'], $trigger['timing'], $trigger['event'], $trigger['table'], $trigger['definition']);
		}
		$this->debug(__METHOD__, 'sql', $sql);
		$status = $this->DBO->exec($sql);
		return($status);
	}

	public function deleteTrigger($database, $trigger){
		$sql = sprintf("DROP TRIGGER `%s`;", $trigger['name']);
		$this->debug(__METHOD__, 'sql', $sql);
		$status = $this->DBO->exec($sql);
		return($status);
	}

	public function renameTrigger($database, $trigger1, $trigger2){
		$status = $this->createTrigger($database, $trigger2);
		if (is_string($status)) return($status);
		$status = $this->deleteTrigger($database, $trigger1);
		return($status);
	}
	
	public function createView($view, $select){
		$this->debug(__METHOD__, 'view', $view);
		$sql = sprintf("CREATE");
		if ($this->driver == 'mysql') {
			$sql.= sprintf(" ALGORITHM=UNDEFINED DEFINER=`ronludwig`@`%%` SQL SECURITY DEFINER");
		}
		$sql.= sprintf(" VIEW `%s` AS", $view);
		$sql.= sprintf(" %s;", $select);
		$this->debug(__METHOD__, 'sql', $sql);
		$status = $this->DBO->exec($sql);
		$this->debug(__METHOD__, 'status', $status);
		return($status);
	}

	public function deleteView($view1){
		$this->debug(__METHOD__, 'view1', $view1);
		$sql = sprintf("DROP VIEW `%s`;", $view1);
		$this->debug(__METHOD__, 'sql', $sql);
		$status = $this->DBO->exec($sql);
		$this->debug(__METHOD__, 'status', $status);
		return($status);
	}

	public function renameView($view1, $view2){
		$this->debug(__METHOD__, 'view1', $view1);
		$this->debug(__METHOD__, 'view2', $view2);
		if ($this->driver == 'sqlite') {
			$record = $this->getView($this->driver, $this->database, $view1);
			$this->debug(__METHOD__, 'RECORD', $record);
			$sql = $record['sql'];
			$sql = str_replace($view1, $view2, $sql);
			$status = $this->createView($view2, $sql);
			$this->debug(__METHOD__, 'createView_status', $status);
			if (!is_string($status)) {
				$status = $this->deleteView($view1);
				$this->debug(__METHOD__, 'deleteView_status', $status);
			}
		} else {
			$sql = sprintf("RENAME TABLE `%s` TO `%s`;", $view1, $view2);
			$this->debug(__METHOD__, 'sql', $sql);
			$status = $this->DBO->exec($sql);
			$this->debug(__METHOD__, 'status', $status);
		}
		return($status);
	}

	public function importFile($database){
		//printf('<PRE>DATABASE = %s</PRE>'."\n", print_r($database));
		//printf('<PRE>FILES = %s</PRE>'."\n", print_r($_FILES));
		$filename = $_FILES["file"]["name"];
		$sql = file_get_contents($_FILES["file"]["tmp_name"]);
		//printf('<PRE>SQL = %s</PRE>'."\n", print_r($sql));
		$status = $this->DBO->exec($sql);
		//printf('<PRE>STATUS = %s</PRE>'."\n", print_r($status));
		return($status);
	}
	
	public function exportFile($dbhost, $database, $table=null){
		//$output = fopen("php://output", "w");
		
		/*
		 printf('<PRE>DBHOST   = %s</PRE>'."\n", print_r($dbhost));
		 printf('<PRE>DATABASE = %s</PRE>'."\n", print_r($database));
		 printf('<PRE>TABLE    = %s</PRE>'."\n", print_r($table));
		 exit;
		 */
		
		$date = date('Y-m-d');
		if (!empty($table)) {
			$filename = sprintf('%s-%s.sql', $table, $date);
		} else {
			$filename = sprintf('%s-%s.sql', $database, $date);
		}
		header('Content-Type: text/plain; charset=utf-8');
		header('Content-Disposition: attachment; filename='.$filename);
		header('Pragma: no-cache');
		header('Expires: 0');
		header('Content-Transfer-Encoding: binary');
		header('Cache-Control: must-revalidate');
		
		printf('-- DBone SQL Export'."\n");
		printf('-- Version: 2.0.1'."\n");
		printf('-- Website: http://www.DBone.us'."\n");
		printf('--'."\n");
		printf('-- Host: %s'."\n", $dbhost);
		printf('-- Date: %s'."\n", date('Y-m-d'));
		printf('-- Time: %s'."\n", date('g:i:s'));
		
		$this->connect($database);
		
		$sql = "SELECT VERSION()";
		$data = $this->DBO->query($sql);
		$server_version = $data[0]['VERSION()'];
		printf('-- Server version: %s'."\n", $server_version);
		printf('-- PHP version: %s'."\n", phpversion());
		
		printf("\n");
		printf('--'."\n");
		printf('-- Database: %s'."\n", $database);
		printf('--'."\n");
		printf("\n");
		
		if (!empty($table)) {
			$tables = array($table);
		} else {
			$tables = $this->getTables($database);
		}
		
		foreach($tables as $table){
			printf('--'."\n");
			printf('-- Export structure for table: %s'."\n", $table);
			printf('--'."\n");
			printf("\n");
			
			$sql = "SHOW CREATE TABLE `$table`";
			$data = $this->DBO->query($sql);
			$stmt = !empty($data[0]['Create Table']) ? $data[0]['Create Table'] : '';
			$stmt = str_replace('CREATE TABLE', 'CREATE TABLE IF NOT EXISTS', $stmt);
			printf('%s;'."\n", $stmt);
			
			printf("\n");
			printf('--'."\n");
			printf('-- Export data for table: %s'."\n", $table);
			printf('--'."\n");
			printf("\n");
			
			//$fields = $this->getFields($database, $table);
			//$columns = $this->getColumns($database, $table);
			
			//printf('<PRE>COLUMNS = %s</PRE>'."\n", print_r($columns));
			
			$data    = $this->getData($database, $table);
			
			$columns = array_keys($data[0]);
			
			$fields  = "`".implode("`,`", $columns)."`";
			
			foreach($data as $rec){
				foreach($rec as $key => $val){
					$rec[$key] = addslashes($val);
				}
				$values = "'".implode("','", $rec)."'";
				printf('INSERT INTO `%s` (%s) VALUES (%s);'."\n", $table, $fields, $values);
			}
		}
		//fclose($output);
		return(true);
	}
	
	public function addColumn($database, $table, $column, $type, $oldcol){
		$sql = sprintf("ALTER TABLE `%s` ADD COLUMN `%s` %s AFTER `%s`;", $table, $column, $type, $oldcol);
		$this->sql($sql);
		$status = $this->DBO->exec($sql);
		return($status);
	}
	
	public function moveColumn($database, $table, $column, $type, $where){
		$sql = sprintf("ALTER TABLE `%s` CHANGE COLUMN `%s` `%s` %s %s;", $table, $column, $column, $type, $where);
		$this->sql($sql);
		$status = $this->DBO->exec($sql);
		return($status);
	}
	
	public function changeColumn($database, $table, $column, $type, $oldcol, $null, $key, $default, $extra){
		$sql = sprintf("ALTER TABLE `%s` CHANGE COLUMN `%s` `%s` %s", $table, $oldcol, $column, $type);
		if ($null == 'NO') {
			$sql.= sprintf(" NOT NULL");
		}
		if (!empty($default)) {
			$sql.= sprintf(" DEFAULT %s", $default);
		}
		$sql.= ';';
		$this->sql($sql);
		$status = $this->DBO->exec($sql);
		return($status);
	}
	
	public function dropColumn($database, $table, $column){
		$sql = sprintf("ALTER TABLE `%s` DROP COLUMN `%s`;", $table, $column);
		$this->debug(__METHOD__, 'sql', $sql);
		$this->sql($sql);
		$status = $this->DBO->exec($sql);
		$this->debug(__METHOD__, 'status', $status);
		return($status);
	}
	
	public function modifyColumn($database, $table, $column, $type){
		$sql = sprintf("ALTER TABLE `%s` MODIFY COLUMN `%s` %s;", $table, $column, $type);
		$this->sql($sql);
		$status = $this->DBO->exec($sql);
		return($status);
	}
	
	public function renameColumn($database, $table, $column1, $column2){
		$sql = sprintf("ALTER TABLE `%s` RENAME COLUMN `%s` TO `%s`;", $table, $column1, $column2);
		$this->debug(__METHOD__, 'sql', $sql);
		$this->sql($sql);
		$status = $this->DBO->exec($sql);
		$this->debug(__METHOD__, 'status', $status);
		return($status);
	}
	
	//ALTER TABLE `links` ADD UNIQUE(`title`);
	//alter table Persion add primary key (persionId,Pname,PMID)
	public function createIndex($database, $table, $column, $type){
		if ($this->driver == 'sqlite'){
			$sql = sprintf("CREATE INDEX `%s` ON %s (`%s`);", $index, $table, $column);
		} else {
			$sql = sprintf("ALTER TABLE `%s` ADD %s (`%s`);", $table, $type, $column);
		}
		$status = $this->DBO->exec($sql);
		return($status);
	}
	
	//ALTER TABLE `links` DROP INDEX `title`;
	public function deleteIndex($database, $table, $column){
		$sql = sprintf("ALTER TABLE `%s` DROP INDEX `%s`;", $table, $column);
		$this->sql($sql);
		$status = $this->DBO->exec($sql);
		return($status);
	}
	
	//ALTER TABLE `links` DROP INDEX `title`;
	public function renameIndex($database, $table, $column, $column2){
		$sql = sprintf("ALTER TABLE `%s` RENAME INDEX `%s` TO `%s`;", $table, $column, $column2);
		$this->sql($sql);
		$status = $this->DBO->exec($sql);
		return($status);
	}
	
	public function deleteRecord($database, $table, $oldrec){
		$conditions = array();
		foreach ($oldrec as $key => $val) {
			$conditions[] = sprintf("`%s` = '%s'", $key, @addslashes($val));
		}
		$condition = implode(' AND ', $conditions);
		$sql = sprintf("DELETE FROM `%s` WHERE %s;", $table, $condition);
		$this->sql($sql);
		$status = $this->DBO->exec($sql);
		return($status);
	}
	
	public function insertRecord($database, $table, $record){
		$rec = array();
		foreach($record as $key => $val) {
			if (!empty($val)) {
				$rec[$key] = addslashes($val);
			}
		}
		$fields = sprintf("`%s`", implode("`,`", array_keys($rec)));
		$values = sprintf("'%s'", implode("','", array_values($rec)));
		$sql = sprintf("INSERT INTO `%s` (%s) VALUES (%s);", $table, $fields, $values);
		$this->sql($sql);
		$status = $this->DBO->exec($sql);
		return($status);
	}
	
	public function updateRecord($database, $table, $record, $record2){
		$sets = array();
		foreach ($record2 as $key => $val) {
			if ($record2[$key] !== $record[$key]) {
				$sets[] = sprintf("`%s` = '%s'", $key, addslashes($val));
			}
		}
		if (empty($sets)) {
			return(0);
		}
		$set = implode(',', $sets);
		$conditions = array();
		foreach ($record as $key => $val) {
			$conditions[] = sprintf("`%s` = '%s'", $key, @addslashes($val));
		}
		$condition = implode(' AND ', $conditions);
		$sql = sprintf("UPDATE `%s` SET %s WHERE %s;", $table, $set, $condition);
		$this->sql($sql);
		$status = $this->DBO->exec($sql);
		return($status);
	}
	
	public function updateRecord3($database, $table, $record, $oldrec){
		$i=0;
		$sets = array();
		foreach($record as $key => $val) {
			if ($i == 0) {
				$field = $key;
				$value = $val;
			}
			if (empty($val)) {
				//$sets[] = sprintf("`%s` = NULL", $key);
			} else {
				$sets[] = sprintf("`%s` = '%s'", $key, addslashes($val));
			}
			$i++;
		}
		$set = implode(',', $sets);
		$conditions = array();
		foreach ($record as $key => $val) {
			if (empty($val)) {
				//$conditions[] = sprintf("`%s` = NULL", $key);
			} else {
				$conditions[] = sprintf("`%s` = '%s'", $key, @addslashes($val));
			}
		}
		$condition = implode(' AND ', $conditions);
		$sql = sprintf("UPDATE `%s` SET %s WHERE `%s` = '%s';", $table, $set, $field, $value);
		$this->sql($sql);
		$affected = $this->DBO->exec($sql);
		return($affected);
	}
	
	public function updateRecord2($database, $table, $record){
		$old_record = $this->row($database, $table, $row);
		$old_record = $old_record[0];
		$i=0;
		$sets = array();
		foreach($new_record as $key => $val) {
			if ($i == 0) {
				$field = $key;
				$value = $val;
			}
			if (empty($val)) {
				//$sets[] = sprintf("`%s` = NULL", $key);
			} else {
				$sets[] = sprintf("`%s` = '%s'", $key, addslashes($val));
			}
			$i++;
		}
		$set = implode(',', $sets);
		$conditions = array();
		foreach ($old_record as $key => $val) {
			if (empty($val)) {
				//$conditions[] = sprintf("`%s` = NULL", $key);
			} else {
				$conditions[] = sprintf("`%s` = '%s'", $key, @addslashes($val));
			}
		}
		$condition = implode(' AND ', $conditions);
		$sql = sprintf("UPDATE `%s` SET %s WHERE %s;", $table, $set, $condition);
		$this->sql($sql);
		$affected = $this->DBO->exec($sql);
		return($affected);
	}
	
	public function isConnected(){
		if (!empty($this->DBO)){
			return(true);
		}
		return(false);
	}
	
	public function isLoggedIn(){
		$driver = !empty($_SESSION['driver']) ? $_SESSION['driver'] : '';
		$dbpass = !empty($_SESSION['dbpass']) ? $_SESSION['dbpass'] : '';
		if ($driver == 'sqlite'){
			return(true);
		}
		if (!empty($dbpass)){
			return(true);
		}
		return(false);
	}
	
	public function isDownloadPage(){
		$downloads = array('csv','export');
		//printf('<PRE>PAGE = %s</PRE>'."\n", $this->page);exit();
		if (in_array($this->page, $downloads)) {
			return(true);
		}
		return(false);
	}
	
	public function isDatabaseSet(){
		if (!empty($_SESSION['database'])){
			return(true);
		}
		return(false);
	}
	
	public function isTableSet(){
		if (!empty($_SESSION['table'])){
			return(true);
		}
		return(false);
	}

	public function goback(){
		printf('<script>'."\n");
		printf('window.history.go(-1);'."\n");
		printf('</script>'."\n");
	}

	public function redirect($page, $database='', $table=''){
		//printf('<PRE>    PAGE = %s</PRE>'."\n", print_r($page));
		//printf('<PRE>DATABASE = %s</PRE>'."\n", print_r($database));
		//printf('<PRE>   TABLE = %s</PRE>'."\n", print_r($table));
		if (!empty($table)) {
			$url = sprintf("./?page=%s&database=%s&table=%s", $page, $database, $table);
		} else if (!empty($database)) {
			//$url = sprintf("./?page=tables&database=%s", $database);
			$url = sprintf("./?page=%s&database=%s", $page, $database);
		} else {
			$url = sprintf("./?page=databases");
			//$url = sprintf("./?page=login");
		}
		//printf('<PRE>URL = %s</PRE>'."\n", print_r($url));
		//header('Location: '.$url);
		echo "<script>window.top.location.href = \"$url\";</script>";
	}
	
	public function redirect3($database, $table){
		//printf('<PRE>DATABASE = %s</PRE>'."\n", print_r($database));
		//printf('<PRE>   TABLE = %s</PRE>'."\n", print_r($table));
		if (!empty($table)) {
			$url = sprintf("./?page=records&database=%s&table=%s", $database, $table);
		} else if (!empty($database)) {
			$url = sprintf("./?page=tables&database=%s", $database);
		} else {
			$url = sprintf("./?page=databases");
		}
		//printf('<PRE>URL = %s</PRE>'."\n", print_r($url));
		//header('Location: '.$url);
		echo "<script>window.top.location.href = \"$url\";</script>";
	}
	
	public function redirect2($url){
		header('Location: '.$url);
	}

	public function debug($method, $name, $value, $mode=null) {
		if (!empty($this->debug) || !empty($mode)) {
			printf('<PRE>%s.%s = %s</PRE>'."\n", $method, $name, print_r($value, 1));
		}
	}

	function raw($rows) {
		printf('<PRE>'."\n");
		foreach($rows as $row){
			printf("%s\n", print_r($row));
		}
		printf('</PRE>'."\n");
	}

	function showData($data, $page, $column, $columns) {
		$this->debug(__METHOD__, 'data', $data);
		$this->debug(__METHOD__, 'page', $page);
		$this->debug(__METHOD__, 'column', $column);
		$this->debug(__METHOD__, 'columns', $columns);
		if (!is_array($data)) return(false);
		$col=0;
		$row=0;
		$totals=array();
		//printf('<center>'."\n");
		printf('<table border="1" width="370px;">'."\n");
		foreach ($data as $rec) {
			if ($row == 0){
				printf('<thead>'."\n");
				printf('<tr>'."\n");
				printf('<th>#</th>'."\n");
				foreach ($rec as $key => $val) {
					$width = $col == 0 ? ' width="100%"' : '';
					$col++;
					printf('<th%s>%s</th>'."\n", $width, strtoupper($key));
					$totals[$key] = 0;
				}
				printf('</tr>'."\n");
				printf('</thead>'."\n");
				printf('<tbody>'."\n");
			}
			$row++;
			$col=0;
			foreach ($rec as $key => $val) {
				if($col == 0){
					printf('<tr onclick="parent.location.href=\'?page=%s&database=%s&table=%s&%s=%s\'">'."\n", $page, $this->database, $this->table, $column, $val);
					printf('<th>%s</th>'."\n", $row);
				}
				$col++;
				if (in_array($key, $columns)) {
					$totals[$key] += intval($val);
					printf('<td align="right">%s</td>'."\n", $val);
				} else {
					printf('<td>%s</td>'."\n", $val);
				}
			}
			printf('</tr>'."\n");
		}
		if (!empty($rec)) {
			printf('<tfoot>'."\n");
			printf('<tr>'."\n");
			printf('<th>&nbsp;</th>'."\n");
			//printf('<th colspan="1">T O T A L</th>'."\n");
			foreach ($rec as $key => $val) {
				if (in_array($key, $columns) && $totals[$key] > 0) {
					printf('<th align="right">%s</td>'."\n", $totals[$key]);
				} else {
					printf('<th>&nbsp;</th>'."\n");
				}
			}
			printf('</tr>'."\n");
			printf('</tfoot>'."\n");
		}
		printf('</tbody>'."\n");
		printf('</table>'."\n");
		//printf('</center>'."\n");
		//printf("<PRE>TOTALS = %s</PRE>\n",print_r($totals));
	}

	function show($rows) {
		//printf("<PRE>COUNT = %s</PRE>\n",print_r(count($rows)));
		//printf("<PRE>SHOW ROWS = %s</PRE>\n",print_r($rows));

		$this->debug(__METHOD__, 'rows', $rows);

		if(!isset($rows[0])){
			$recs = array();
			//$recs[] = array('key' => 'value');
			foreach($rows as $key => $val){
				$recs[] = array('key' => $key, 'value' => $val);
			}
			$rows = $recs;
		}
		//printf("<PRE>NEW ROWS = %s</PRE>\n",print_r($rows));
		
		//$rows = empty($rows[0]) ? array($rows) : $rows;
		$bolds   = array('bday','ddate','mdate');
		$centers = array('age','bdate','bday','byear','lived','mday','mobile','myear','myears','state','year','years');
		$rights  = array();
		$n=0;
		//printf('<table border="1" width="100%%">'."\n");
		printf('<table border="1">'."\n");
		foreach ($rows as $row) {
			//printf("<PRE>%s</PRE>\n",print_r($row));
			if ($n == 0){
				printf("<tr>\n");
				printf("<th>#</th>\n");
				foreach ($row as $key => $val) {
					printf("<th>%s</th>\n", strtoupper($key));
				}
				printf("</tr>\n");
			}
			$n++;
			printf("<tr>\n");
			printf("<th>%s</th>\n", $n);
			foreach ($row as $key => $val) {
				printf("<td>%s</td>\n", print_r($val));
				/*
				 if (in_array($key, $bolds)){
				 printf('<td align="center" style="font-weight:bold;">%s</td>'."\n", $val);
				 } else if (in_array($key, $centers)){
				 printf('<td align="center">%s</td>'."\n", $val);
				 } else if (in_array($key, $rights)){
				 printf('<td align="right">%s</td>'."\n", $val);
				 } else {
				 printf("<td>%s</td>\n", print_r($val));
				 }
				 */
			}
			printf("</tr>\n");
		}
		printf("</table>\n");
	}

	function showMenu($items, $page, $database=null) {
		//printf("<PRE>%s</PRE>\n",print_r($row));
		printf('<menu>'."\n");
		printf('<table>'."\n");
		printf('<thead>'."\n");
		printf('<tr>'."\n");
		foreach ($items as $item) {
			$class = strtolower($item) == strtolower($page) ? 'on' : 'off';
			printf('<th class="%s" onclick="parent.location.href=\'?page=%s&database=%s\'">%s</th>'."\n", $class, $item, $database, strtoupper($item));
		}
		printf('</tr>'."\n");
		printf('</thead>'."\n");
		printf('</table>'."\n");
		printf('</menu>'."\n");
	}
	
	function showDatabaseMenu($page) {
		$items = array('database','views','routines','events','triggers');
		$this->showMenu($items, $page);
	}
	
	function showTableMenu($page, $database) {
		$items = array('table','views');
		$this->showMenu($items, $page, $database);
	}
	
	
	public function showResults($data){
		//$this->debug(__METHOD__, 'data', $data);
		printf('<table border="1">'."\n");
		$n=0;
		foreach ($data as $rec) {
			if ($n == 0){
				printf("<tr>\n");
				printf("<th>#</th>\n");
				foreach ($rec as $key => $val) {
					printf("<th>%s</th>\n", strtoupper($key));
				}
				printf("</tr>\n");
			}
			$n++;
			printf("<tr>\n");
			printf("<th>%s</th>\n", $n);
			foreach ($rec as $key => $val) {
				printf("<td>%s</td>\n", print_r($val, 1));
			}
			printf("</tr>\n");
		}
		printf("</table>\n");
	}
}

class Login extends DBone {
	
	public function controller(){
		$this->connections = $this->getConnections();
		//$this->model();
		$command = !empty($_REQUEST['command']) ? $_REQUEST['command'] : '';
		if ($command == 'login') {
			$dbo = new DBO();
			$status = $dbo->connect($this->driver, $this->dbhost, $this->dbport, $this->charset, $this->dbuser, $this->dbpass, $this->database);
			if ($status === true) {
				$_SESSION['driver']   = !empty($this->driver)   ? $this->driver   : '';
				$_SESSION['dbpath']   = !empty($this->dbpath)   ? $this->dbpath   : '';
				$_SESSION['dbhost']   = !empty($this->dbhost)   ? $this->dbhost   : '';
				$_SESSION['dbport']   = !empty($this->dbport)   ? $this->dbport   : '';
				$_SESSION['charset']  = !empty($this->charset)  ? $this->charset  : '';
				$_SESSION['dbuser']   = !empty($this->dbuser)   ? $this->dbuser   : '';
				$_SESSION['dbpass']   = !empty($this->dbpass)   ? $this->dbpass   : '';
				$_SESSION['database'] = !empty($this->database) ? $this->database : '';
				$_SESSION['table']    = !empty($this->table)    ? $this->table    : '';

				$page     = !empty($this->page)     ? $this->page     : 'databases';
				$query    = !empty($this->query)    ? $this->query    : '';
				$database = !empty($this->database) ? $this->database : '';
				$table    = !empty($this->table)    ? $this->table    : '';

				//printf('<PRE>PAGE     = %s</PRE>'."\n", print_r($page,1));
				//printf('<PRE>DATABASE = %s</PRE>'."\n", print_r($database,1));
				//printf('<PRE>TABLE    = %s</PRE>'."\n", print_r($table,1));
				//exit();
				
				$this->redirect($page, $database, $table);
			} else {
				printf('<PRE>ERROR2: %s</PRE>'."\n", print_r($status,1));
				//session_destroy();
			}
		} else {
			parent::controller();
		}
	}

	public function model(){

		/*
		$command = !empty($_REQUEST['command']) ? $_REQUEST['command'] : '';
		//printf('<PRE>COMMAND2 = %s</PRE>'."\n", print_r($command,1));
		if ($command == 'login') {
			$this->data['driver']   = isset($_POST['driver'])   ? $_POST['driver']   : $_SESSION['driver'];
			$this->data['dbpath']   = isset($_POST['dbpath'])   ? $_POST['dbpath']   : $_SESSION['dbpath'];
			$this->data['dbhost']   = isset($_POST['dbhost'])   ? $_POST['dbhost']   : $_SESSION['dbhost'];
			$this->data['dbport']   = isset($_POST['dbport'])   ? $_POST['dbport']   : $_SESSION['dbport'];
			$this->data['charset']  = isset($_POST['charset'])  ? $_POST['charset']  : $_SESSION['charset'];
			$this->data['dbuser']   = isset($_POST['dbuser'])   ? $_POST['dbuser']   : $_SESSION['dbuser'];
			$this->data['dbpass']   = isset($_POST['dbpass'])   ? $_POST['dbpass']   : $_SESSION['dbpass'];
			$this->data['database'] = isset($_POST['database']) ? $_POST['database'] : $_SESSION['database'];
			$this->data['table']    = isset($_POST['table'])    ? $_POST['table']    : $_SESSION['table'];
			//$this->data['database'] = isset($_POST['database']) ? $_POST['database'] : '';
			//$this->data['table']    = isset($_POST['table'])    ? $_POST['table']    : '';
			//$this->data['database'] = '';
			//$this->data['table']    = '';

			$this->data['driver']   = !empty($_POST['driver'])   ? $_POST['driver']   : '';
			$this->data['dbpath']   = !empty($_POST['dbpath'])   ? $_POST['dbpath']   : '';
			$this->data['dbhost']   = !empty($_POST['dbhost'])   ? $_POST['dbhost']   : '';
			$this->data['dbport']   = !empty($_POST['dbport'])   ? $_POST['dbport']   : '';
			$this->data['charset']  = !empty($_POST['charset'])  ? $_POST['charset']  : '';
			$this->data['dbuser']   = !empty($_POST['dbuser'])   ? $_POST['dbuser']   : '';
			$this->data['dbpass']   = !empty($_POST['dbpass'])   ? $_POST['dbpass']   : '';
			$this->data['database'] = !empty($_POST['database']) ? $_POST['database'] : '';
			$this->data['table']    = !empty($_POST['table'])    ? $_POST['table']    : '';
		} else {
			$this->data['driver']   = !empty($_SESSION['driver'])   ? $_SESSION['driver']   : '';
			$this->data['dbpath']   = !empty($_SESSION['dbpath'])   ? $_SESSION['dbpath']   : '';
			$this->data['dbhost']   = !empty($_SESSION['dbhost'])   ? $_SESSION['dbhost']   : '';
			$this->data['dbport']   = !empty($_SESSION['dbport'])   ? $_SESSION['dbport']   : '';
			$this->data['charset']  = !empty($_SESSION['charset'])  ? $_SESSION['charset']  : '';
			$this->data['dbuser']   = !empty($_SESSION['dbuser'])   ? $_SESSION['dbuser']   : '';
			$this->data['dbpass']   = !empty($_SESSION['dbpass'])   ? $_SESSION['dbpass']   : '';
			$this->data['database'] = !empty($_SESSION['database']) ? $_SESSION['database'] : '';
			$this->data['table']    = !empty($_SESSION['table'])    ? $_SESSION['table']    : '';
		}
		$this->data['drivers']  = $this->getDrivers();
		*/

		$this->drivers = $this->getDrivers();
	}

	public function view(){
		//$this->showHead();
		printf('<section>'."\n");
		printf('<h2>L O G I N</h2>'."\n");
		printf('<form action="./?frame=body&page=login" method="post" target="body">'."\n");
		printf('<table>'."\n");

		printf('<tr>'."\n");
		printf('<th align="right"><label for="connection">Connection:</label></th>'."\n");
		printf('<td colspan="2">'."\n");
		printf('<select id="connection" name="connection" onchange="this.form.submit()">'."\n");
		printf('<option value="">SELECT CONNECTION</option>'."\n");
		foreach($this->connections as $connection => $data){
			$selected = $connection == $this->connection ? ' SELECTED' : '';
			if ($connection == $this->connection) {
				$this->driver   = !empty($data['driver'])   ? $data['driver']   : '';
				$this->dbpath   = !empty($data['dbpath'])   ? $data['dbpath']   : '';
				$this->dbhost   = !empty($data['dbhost'])   ? $data['dbhost']   : '';
				$this->dbport   = !empty($data['dbport'])   ? $data['dbport']   : '';
				$this->charset  = !empty($data['charset'])  ? $data['charset']  : '';
				$this->dbuser   = !empty($data['dbuser'])   ? $data['dbuser']   : '';
				$this->dbpass   = !empty($data['dbpass'])   ? $data['dbpass']   : '';
				$this->database = !empty($data['database']) ? $data['database'] : '';
				$this->table    = !empty($data['table'])    ? $data['table']    : '';
			}
			printf('<option value="%s"%s>%s</option>'."\n", $connection, $selected, $connection);
		}
		printf('</select>'."\n");
		printf('</td>'."\n");
		printf('</tr>'."\n");
		
		printf('<tr>'."\n");
		printf('<th align="right"><label for="driver">Driver:</label></th>'."\n");
		printf('<td colspan="2">'."\n");
		printf('<select id="driver" name="driver" onchange="this.form.submit()">'."\n");
		printf('<option value="">SELECT DRIVER</option>'."\n");
		foreach($this->drivers as $key => $val){
			$selected = $key == $this->driver ? ' SELECTED' : '';
			$disabled = $val == '0' ? ' DISABLED' : '';
			printf('<option value="%s"%s%s>%s</option>'."\n", $key, $disabled, $selected, $key);
		}
		printf('</select>'."\n");
		printf('</td>'."\n");
		printf('</tr>'."\n");
		
		if ($this->driver == 'sqlite') {
			$this->dbpath = !empty($this->dbpath) ? $this->dbpath : '';
			printf('<tr>'."\n");
			printf('<th align="right"><label for="dbpath">Path:</label></th>'."\n");
			printf('<td colspan="2"><input id="dbpath" name="dbpath" type="text" value="%s" required/></td>'."\n", $this->dbpath);
			printf('</tr>'."\n");
			
			printf('<tr>'."\n");
			printf('<th align="right"><label for="database">Database:</label></th>'."\n");
			printf('<td colspan="2"><input id="database" name="database" type="text" value="%s" placeholder="(optional)"/></td>'."\n", $this->database);
			printf('</tr>'."\n");
			
		} else {
			
			printf('<tr>'."\n");
			printf('<th align="right"><label for="dbhost">Hostname:</label></th>'."\n");
			printf('<td colspan="2"><input id="dbhost" name="dbhost" type="text" value="%s" required/></td>'."\n", $this->dbhost);
			printf('</tr>'."\n");
			
			printf('<tr>'."\n");
			printf('<th align="right"><label for="dbport">Hostport:</label></th>'."\n");
			printf('<td colspan="2"><input id="dbport" name="dbport" type="text" value="%s" required/></td>'."\n", $this->dbport);
			printf('</tr>'."\n");
			
			printf('<tr>'."\n");
			printf('<th align="right"><label for="charset">Charset:</label></th>'."\n");
			printf('<td colspan="2"><input id="charset" name="charset" type="text" value="%s" required/></td>'."\n", $this->charset);
			printf('</tr>'."\n");
			
			printf('<tr>'."\n");
			printf('<th align="right"><label for="dbuser">Username:</label></th>'."\n");
			printf('<td colspan="2"><input id="dbuser" name="dbuser" type="text" value="%s" required autofocus/></td>'."\n", $this->dbuser);
			printf('</tr>'."\n");
			
			printf('<tr>'."\n");
			printf('<th align="right"><label for="dbpass">Password:</label></th>'."\n");
			printf('<td><input id="dbpass" name="dbpass" type="password" value="%s" required/></td><td><input type="checkbox" onclick="var x=document.getElementById(\'dbpass\');if(x.type === \'password\'){x.type = \'text\';}else{x.type = \'password\';}"</td>'."\n", $this->dbpass);
			printf('</tr>'."\n");
			
			printf('<tr>'."\n");
			printf('<th align="right"><label for="database">Database:</label></th>'."\n");
			printf('<td colspan="2"><input id="database" name="database" type="text" value="%s" placeholder="(optional)"/></td>'."\n", $this->database);
			printf('</tr>'."\n");
			
			printf('<tr>'."\n");
			printf('<th align="right"><label for="table">Table:</label></th>'."\n");
			printf('<td colspan="2"><input id="table" name="table" type="text" value="%s" placeholder="(optional)"/></td>'."\n", $this->table);
			printf('</tr>'."\n");
		}

		printf('<tfoot>'."\n");
		printf('<tr>'."\n");
		printf('<th></th>'."\n");
		printf('<th colspan="2"><button id="command" name="command" type="submit" value="login" style="width:98%%">LOGIN</button></th>'."\n");
		printf('</tr>'."\n");
		printf('</tfoot>'."\n");

		printf('</table>'."\n");
		printf('</form>'."\n");
		printf('</section>'."\n");
		//$this->showFoot();
	}

	public function view2(){
		//$this->head();
		
		printf('<h2>L O G I N</h2>'."\n");
		
		//printf('<form method="post">'."\n");
		//printf('<form action="./?page=login" method="post" target="_parent">'."\n");
		//printf('<form method="post" target="_parent">'."\n");
		//printf('<form action="./" method="post" target="_parent">'."\n");
		//printf('<form action="./?frame=body" method="post" target="_parent">'."\n");
		
		printf('<form action="./?frame=body&page=login" method="post" target="body">'."\n");
		
		//printf('<input name="frame" type="hidden" value="body"/>'."\n");
		
		printf('<table border="1">'."\n");
		printf('<tr>'."\n");
		printf('<th align="right"><label for="driver">Driver:</label></th>'."\n");
		printf('<td colspan="2">'."\n");
		printf('<select id="driver" name="driver" onchange="this.form.submit()">'."\n");
		foreach($this->data['drivers'] as $key => $val){
			$selected = $key == $this->data['driver'] ? ' SELECTED' : '';
			$disabled = $val == '0'     ? ' DISABLED' : '';
			printf('<option value="%s"%s%s>%s</option>'."\n", $key, $disabled, $selected, $key);
		}
		printf('</select>'."\n");
		printf('</td>'."\n");
		printf('</tr>'."\n");
		
		if ($this->data['driver'] == 'sqlite') {
			printf('<tr>'."\n");
			printf('<th align="right"><label for="dbpath">Path:</label></th>'."\n");
			printf('<td colspan="2"><input id="dbpath" name="dbpath" type="text" value="%s" required/></td>'."\n", $this->data['dbpath']);
			printf('</tr>'."\n");
			
			printf('<tr>'."\n");
			printf('<th align="right"><label for="database">Database:</label></th>'."\n");
			printf('<td colspan="2"><input id="database" name="database" type="text" value="%s" placeholder="(optional)"/></td>'."\n", $this->data['database']);
			printf('</tr>'."\n");
			
		} else {
			
			printf('<tr>'."\n");
			printf('<th align="right"><label for="dbhost">Hostname:</label></th>'."\n");
			printf('<td colspan="2"><input id="dbhost" name="dbhost" type="text" value="%s" required/></td>'."\n", $this->data['dbhost']);
			printf('</tr>'."\n");
			
			printf('<tr>'."\n");
			printf('<th align="right"><label for="dbport">Hostport:</label></th>'."\n");
			printf('<td colspan="2"><input id="dbport" name="dbport" type="text" value="%s" required/></td>'."\n", $this->data['dbport']);
			printf('</tr>'."\n");
			
			printf('<tr>'."\n");
			printf('<th align="right"><label for="charset">Charset:</label></th>'."\n");
			printf('<td colspan="2"><input id="charset" name="charset" type="text" value="%s" required/></td>'."\n", $this->data['charset']);
			printf('</tr>'."\n");
			
			printf('<tr>'."\n");
			printf('<th align="right"><label for="dbuser">Username:</label></th>'."\n");
			printf('<td colspan="2"><input id="dbuser" name="dbuser" type="text" value="%s" required autofocus/></td>'."\n", $this->data['dbuser']);
			printf('</tr>'."\n");
			
			printf('<tr>'."\n");
			printf('<th align="right"><label for="dbpass">Password:</label></th>'."\n");
			printf('<td><input id="dbpass" name="dbpass" type="password" value="%s" required/></td><td><input type="checkbox" onclick="var x=document.getElementById(\'dbpass\');if(x.type === \'password\'){x.type = \'text\';}else{x.type = \'password\';}"</td>'."\n", $this->data['dbpass']);
			printf('</tr>'."\n");
			
			printf('<tr>'."\n");
			printf('<th align="right"><label for="database">Database:</label></th>'."\n");
			printf('<td colspan="2"><input id="database" name="database" type="text" value="%s" placeholder="(optional)"/></td>'."\n", $this->data['database']);
			printf('</tr>'."\n");
			
			printf('<tr>'."\n");
			printf('<th align="right"><label for="table">Table:</label></th>'."\n");
			printf('<td colspan="2"><input id="table" name="table" type="text" value="%s" placeholder="(optional)"/></td>'."\n", $this->data['table']);
			printf('</tr>'."\n");
		}
		
		printf('<tr>'."\n");
		printf('<th></th>'."\n");
		printf('<th colspan="2"><button id="command" name="command" type="submit" value="login" style="width:100%%">LOGIN</button></th>'."\n");
		printf('</tr>'."\n");
		
		printf('</table>'."\n");
		printf('</form>'."\n");
		printf('</center>'."\n");
		//$this->foot();
	}
}

class Logout extends DBone {
	
	public function controller(){
		parent::controller();
	}
	
	public function model(){
		if (isset($_SESSION)) session_destroy();
		
		# CALCULATE HOW LONG LOGGEDIN
		$accessed = '';
		
		$this->data = array('Accessed' => $accessed);
		//printf("<PRE>DATA = %s</PRE>\n",print_r($data,1));
	}
	
	public function view(){
		$n=0;
		printf('<h1>%s</h1>'."\n", 'Logout');
		printf('<h3>%s</h3>'."\n", 'You are now Logged-Out!');
	}
}

class Databases extends DBone {
	
	public function controller(){
		parent::controller();
	}
	
	public function model(){
		if ($this->driver == 'sqlite') {
			//printf('<PRE>DIR = %s</PRE>'."\n", print_r($this->dbpath,1));
			$files = scandir($this->dbpath);
			//printf('<PRE>FILES = %s</PRE>'."\n", print_r($files,1));
			$databases = array();
			foreach($files as $file) {
				if (strpos($file, '.') == 0) continue;
				$database = substr($file, 0, strrpos($file, "."));
				//if (in_array($database, $forbidden)) continue;
				$this->connect($database);
				$sql = "SELECT name FROM sqlite_master WHERE type='table' AND name NOT LIKE 'sqlite_%'";
				//printf('<PRE>SQL = %s</PRE>'."\n", print_r($sql,1));
				$this->data = $this->DBO->query($sql);
				//printf('<PRE>DATA = %s</PRE>'."\n", print_r($this->data,1));
				$tables   = count($this->data);
				$rec['database'] = $database;
				$rec['tables']   = $tables;
				$databases[] = $rec;
			}
			$this->data = $databases;
		} else {
			$databases = $this->getDatabases();
			//printf('<PRE>DATABASES = %s</PRE>'."\n", print_r($databases,1));
			$this->data = array();
			foreach($databases as $database) {
				//if (in_array($database, $this->forbidden)) continue;
				//$this->connect($database);
				$sql = "SHOW TABLES FROM `$database`";
				$this->debug(__METHOD__, 'SQL', $sql);
				$tables = $this->DBO->query($sql);
				$this->debug(__METHOD__, 'TABLES', $tables);
				$this->data[] = array('database' => $database, 'tables' => count($tables));
			}
		}
	}

	public function view(){
		$page = 'objects';
		$column = 'database';
		$columns = array('tables');
		printf('<h2>DATABASES</h2>'."\n");
		$this->showData($this->data, $page, $column, $columns);
	}
}

class Objects extends DBone {

	public function controller(){
		$this->debug(__METHOD__, 'REQUEST', $_REQUEST);
		$this->debug(__METHOD__, 'THIS', $this);

		$this->showHead();
		$this->showStatus();

		$tables = new Tables();
		$tables->getRequest();
		$tables->model();
		$tables->view();

		$views = new Views();
		$views->getRequest();
		$views->model();
		$views->view();

		if (class_exists('Triggers')) {
			$triggers = new Triggers();
			$triggers->getRequest();
			$triggers->model();
			$triggers->view();
		}
		if (class_exists('Events')) {
			$events = new Events();
			$events->getRequest();
			$events->model();
			$events->view();
		}
		if (class_exists('Routines')) {
			$routines = new Routines();
			$routines->getRequest();
			$routines->model();
			$routines->view();
		}
		$this->showFoot();
	}

	public function model(){
	}

	public function view(){
	}
}

class Tables extends DBone {

	public function controller(){
		parent::controller();
	}

	public function model(){
		$this->data = array();
		$this->connect($this->database);
		$tables = $this->getTables($this->driver, $this->database);
		foreach($tables as $rec){
			$table = $rec['table'];
			$rows = $this->getRows($this->driver, $this->database, $table);
			$row['table'] = $table;
			$row['rows']  = $rows;
			$this->data[] = $row;
		}
	}

	public function view(){
		printf('<h2><a href="?page=tables&database=%s" target="_parent">TABLES</a></h2>'."\n", $this->database);
		$page = 'records';
		$column = 'table';
		$columns = array('rows');
		$this->showData($this->data, $page, $column, $columns);
	}
}

class Views extends DBone {

	public function controller(){
		parent::controller();
	}

	public function model(){
		$this->connect($this->database);
		$data = $this->getViews($this->driver, $this->database);
		foreach($data as $rec){
			$view = $rec['view'];
			$rows = $this->getRows($this->driver, $this->database, $view);
			$row['view'] = $view;
			$row['rows']  = $rows;
			$this->data[] = $row;
		}
	}
	
	public function view(){
		printf('<h2><a href="?page=views&database=%s" target="_parent">VIEWS</a></h2>'."\n", $this->database);
		$page    = 'records';
		$column  = 'view';
		$columns = array('rows');
		$this->showData($this->data, $page, $column, $columns);
	}
}

class Records extends DBone {
	
	public function controller(){
		parent::controller();
	}
	
	public function model(){
		$this->connect($this->database);
		$table = !empty($this->table) ? $this->table : $this->view;
		$sql = "SELECT * FROM `$table`";
		if (!empty($this->field)) {
			$sql.= " ORDER BY `$this->field` $this->order";
		}
		$this->data = $this->DBO->query($sql);
	}
	
	public function view(){
		printf('<h2>RECORDS</h2>'."\n");
		$row=0;
		printf('<table border="1" width="100%%;">'."\n");
		foreach ($this->data as $rec) {
			if ($row == 0){
				printf('<thead>'."\n");
				printf('<tr>'."\n");
				printf('<th>#</th>'."\n");
				foreach ($rec as $key => $val) {
					printf('<th onclick="parent.location.href=\'?page=records&database=%s&table=%s&view=%s&field=%s\'">%s</th>'."\n", $this->database, $this->table, $this->view, $key, strtoupper($key));
				}
				printf('</tr>'."\n");
				printf('</thead>'."\n");
				printf('<tbody>'."\n");
			}
			$row++;
			$col=0;
			foreach ($rec as $key => $val) {
				if ($col == 0) {
					$page = 'records';
					$primary   = 'records';
					$secondary = 'record';
					$secondary = class_exists($secondary) ? $secondary : $primary;
					$page2 = $page == $primary ? $secondary : $primary;
					if (!empty($this->table)) {
						printf('<tr onclick="parent.location.href=\'?page=%s&database=%s&table=%s&key=%s&val=%s\'">'."\n", $page2, $this->database, $this->table, $key, $val);
					} else if (!empty($this->view)) {
						printf('<tr onclick="parent.location.href=\'?page=%s&database=%s&view=%s&key=%s&val=%s\'">'."\n", $page2, $this->database, $this->view, $key, $val);
					} else {
						printf('<tr onclick="parent.location.href=\'?page=tables&database=%s\'">'."\n", $page2, $this->database);
					}
					printf('<th>%s</th>'."\n", $row);
				}
				$col++;
				printf('<td>%s</td>'."\n", $val);
			}
			printf('</tr>'."\n");
		}
		printf('</tbody>'."\n");
		printf('</table>'."\n");
	}
}

class Record extends DBone {
	
	public function controller(){
		//$this->getRequest();

		$this->debug(__METHOD__, 'REQUEST', $_REQUEST);

		$this->connect($this->database);

		$status = 0;
		if ($this->command == 'delete') {
			$status = $this->deleteRecord($this->database, $this->table, $this->record1);
			if (!is_string($status)) {
				$this->notice("Record was deleted!");
				$this->redirect('records', $this->database, $this->table);
				return(true);
			} else {
				$this->error($status);
			}
		} else if ($this->command == 'insert') {
			$status = $this->insertRecord($this->database, $this->table, $this->record2);
			if (!is_string($status)) {
				$this->notice("Record was inserted!");
				$this->redirect('records', $this->database, $this->table);
				return(true);
			} else {
				$this->error($status);
			}
		} else if ($this->command == 'update') {
			$status = $this->updateRecord($this->database, $this->table, $this->record1, $this->record2);
			if (!is_string($status)) {
				$this->notice("Record was updated!");
				$this->redirect('records', $this->database, $this->table);
				return(true);
			} else {
				$this->error($status);
			}
		} else {
			parent::controller();
		}
		
		$this->debug(__METHOD__, 'REQUEST', $_REQUEST);
		
		if (is_string($status)) {
			$this->data = array();
			$this->data[] = $this->record;
		} else {
			//$this->model();
		}
		//$this->view();
	}

	public function model(){
		if (!empty($this->key)) {
			$sql = "SELECT * FROM `$this->table`";
			$sql.= " WHERE `$this->key` = '$this->val'";
			$this->debug(__METHOD__, 'sql', $sql);
			$this->data = $this->DBO->query($sql);
			$this->debug(__METHOD__, 'data', $this->data);
		} else {
			$this->debug(__METHOD__, 'data', $this->data);
			
			$data = $this->getColumns($this->database, $this->table);
			$this->debug(__METHOD__, 'columns', $data,1);
			
			$this->data = array();
			foreach($data as $rec) {
				$this->data[] = array($rec['column'] => '');
			}
		}
		$this->debug(__METHOD__, 'data', $this->data);
	}

	public function view(){
		printf('<h2>RECORD</h2>'."\n");
		$row=0;
		printf('<form method="post">'."\n");
		foreach($this->data as $rec) {
			foreach($rec as $key => $val) {
				printf('<input name="record1[%s]" type="hidden" value="%s"/>'."\n", $key, $val);
			}
		}
		printf('<table width="370">'."\n");
		printf('<tbody>'."\n");
		//printf("<caption>%s</caption>\n", $caption);
		$valFlag = 0;
		foreach($this->data as $rec) {
			foreach($rec as $key => $val) {
				printf('<tr><th style="text-align:left">&nbsp;%s&nbsp;</th><td width="98%%"><input name="record2[%s]" type="text" value="%s" style="width:98%%;"></td></tr>'."\n", ucfirst($key), $key, $val);
				if (!empty($val)) {
					$valFlag = 1;
				}
			}
		}
		printf('</tbody>'."\n");
		printf('<tfoot>'."\n");
		
		if (!empty($valFlag)) {
			printf('<tr>'."\n");
			printf('<th></th>'."\n");
			printf('<th>'."\n");
			printf('<button onclick="window.history.go(-1); return false;">Cancel</button>'."\n");
			printf('<button onclick="return clearInputs();">Clear</button>'."\n");
			printf('<button type="reset">Reset</button>'."\n");
			printf('</th></tr>'."\n");
			printf('<tr><th></th><th>'."\n");
			printf('<button id="delete" name="command" type="submit" value="delete" onclick="return confirm(\'Delete record?\');">Delete</button>'."\n");
			printf('<button id="insert" name="command" type="submit" value="insert">Insert</button>'."\n");
			printf('<button id="update" name="command" type="submit" value="update">Update</button>'."\n");
			printf('</th>'."\n");
			printf('</tr>'."\n");
		} else {
			printf('<tr>'."\n");
			printf('<th></th>'."\n");
			printf('<th>'."\n");
			printf('<button id="cancel" onclick="window.history.go(-1); return false;">Cancel</button>'."\n");
			printf('<button id="clear" onclick="return clearInputs();">Clear</button>'."\n");
			printf('<button id="reset" type="reset">Reset</button>'."\n");
			printf('</th></tr>'."\n");
			printf('<tr><th></th><th>'."\n");
			printf('<button id="insert" name="command" type="submit" value="insert" style="width:250px;">Insert</button>'."\n");
			printf('</th>'."\n");
			printf('</tr>'."\n");
		}
		printf('</tfoot>'."\n");
		printf('</table>'."\n");
		printf('</form>'."\n");
		printf('</center>'."\n");
	}
	
	public function view2(){
		$this->head();
		printf('<h2>NEW RECORD</h2>'."\n");
		$row=0;
		printf('<form method="post">'."\n");
		foreach($this->data as $rec) {
			foreach($rec as $key => $val) {
				printf('<input name="record1[%s]" type="hidden" value="%s"/>'."\n", $key, $val);
			}
		}
		printf('<table width="370">'."\n");
		printf('<tbody>'."\n");
		//printf("<caption>%s</caption>\n", $caption);
		foreach($this->data as $rec) {
			foreach($rec as $key => $val) {
				printf('<tr><th style="text-align:left">&nbsp;%s&nbsp;</th><td width="98%%"><input name="record2[%s]" type="text" value="%s" style="width:98%%;"></td></tr>'."\n", ucfirst($key), $key, $val);
			}
		}
		printf('</tbody>'."\n");
		printf('<tfoot>'."\n");
		printf('<tr>'."\n");
		printf('<th></th>'."\n");
		printf('<th>'."\n");
		printf('<button onclick="window.history.go(-1); return false;">Cancel</button>'."\n");
		printf('<button onclick="return clearInputs();">Clear</button>'."\n");
		printf('<button type="reset">Reset</button>'."\n");
		printf('</th></tr>'."\n");
		printf('<tr><th></th><th>'."\n");
		printf('<button id="delete" name="command" type="submit" value="delete" onclick="return confirm(\'Delete record?\');">Delete</button>'."\n");
		printf('<button id="insert" name="command" type="submit" value="insert">Insert</button>'."\n");
		printf('<button id="update" name="command" type="submit" value="update">Update</button>'."\n");
		printf('</th>'."\n");
		printf('</tr>'."\n");
		printf('</tfoot>'."\n");
		printf('</table>'."\n");
		printf('</form>'."\n");
		printf('</center>'."\n");
		$this->foot();
	}
}

class Columns extends DBone {

	public function controller(){
		parent::controller();
	}

	public function model(){
		$this->connect($this->database);
		$this->data = $this->getColumns($this->database, $this->table);
		$this->debug(__METHOD__, 'DATA', $this->data);
	}

	public function view(){
		printf('<h2><a href="?page=columns&database=%s&table=%s" target="_parent">COLUMNS</a></h2>'."\n", $this->database, $this->table);
		$page = 'column';
		$column = 'column';
		$columns = array();
		$this->showData($this->data, $page, $column, $columns);
	}
}

class Insert extends DBone {
	
	public function controller(){
		$_SESSION['database'] = !empty($_REQUEST['database']) ? $_REQUEST['database'] : $_SESSION['database'];
		$_SESSION['table']    = !empty($_REQUEST['table'])    ? $_REQUEST['table']    : $_SESSION['table'];
		$this->database = !empty($_SESSION['database']) ? $_SESSION['database'] : '';
		$this->table    = !empty($_SESSION['table'])    ? $_SESSION['table']    : '';
		$this->command  = !empty($_REQUEST['command'])  ? $_REQUEST['command']  : '';
		$this->record   = !empty($_REQUEST['record'])   ? $_REQUEST['record']   : array();
		
		//printf("<PRE>DATABASE = %s</PRE>\n",print_r($this->database,1));
		//printf("<PRE>   TABLE = %s</PRE>\n",print_r($this->table,1));
		
		$this->connect($this->database);
		
		if ($this->command == 'insert') {
			$status = $this->insertRecord($this->database, $this->table, $this->record);
			if (!is_string($status)) {
				$this->notice("New Record was inserted!");
				$this->redirect('records', $this->database, $this->table);
				return(true);
			} else {
				$this->error($status);
			}
		}
		$this->model();
		$this->view();
	}
	
	public function model(){
		$this->data = $this->getColumns($this->database, $this->table);
		//printf("<PRE>DATA = %s</PRE>\n",print_r($this->data,1));
	}
	
	public function view(){
		$this->head();
		$this->showStatus();
		printf('<h2>%s</h2>'."\n", $this->table);
		printf('<form method="post">'."\n");
		printf('<table width="370">'."\n");
		printf('<tbody>'."\n");
		foreach($this->data as $key) {
			printf('<tr><th style="text-align:left">&nbsp;%s&nbsp;</th><td width="98%%"><input name="record[%s]" type="text" value="" style="width:98%%;"></td></tr>'."\n", ucfirst($key), $key);
		}
		printf('</tbody>'."\n");
		printf('<tfoot>'."\n");
		printf('<tr>'."\n");
		printf('<th></th>'."\n");
		printf('<th>'."\n");
		printf('<button onclick="window.history.go(-1); return false;">Cancel</button>'."\n");
		printf('<button onclick="return clearInputs();">Clear</button>'."\n");
		printf('<button type="reset">Reset</button>'."\n");
		printf('</th></tr>'."\n");
		printf('<tr><th></th><th>'."\n");
		printf('<button id="insert" name="command" type="submit" value="insert">Insert</button>'."\n");
		printf('</th>'."\n");
		printf('</tr>'."\n");
		printf('</tfoot>'."\n");
		printf('</table>'."\n");
		printf('</form>'."\n");
		printf('</center>'."\n");
		$this->foot();
	}
}

class Search extends DBone {
	
	public function controller(){
		$this->driver   = !empty($_SESSION['driver'])   ? $_SESSION['driver']   : '';
		$this->database = !empty($_SESSION['database']) ? $_SESSION['database'] : '';
		$this->table    = !empty($_SESSION['table'])    ? $_SESSION['table']    : '';
		$this->query    = !empty($_REQUEST['query'])    ? $_REQUEST['query']    : '';
		
		//printf("<PRE>DATABASE = %s</PRE>\n",print_r($this->database,1));
		//printf("<PRE>   TABLE = %s</PRE>\n",print_r($this->table,1));
		//printf("<PRE>   QUERY = %s</PRE>\n",print_r($this->query,1));
		//$this->connect($this->database);
		//printf("<PRE>DATABASE = [%s]</PRE>\n",print_r($this->database,1));
		
		$databases = array();
		if (!empty($_SESSION['database'])) {
			$databases[] = $_SESSION['database'];
			//printf("<PRE>DATABASES1 = %s</PRE>\n",print_r($databases,1));
		} else {
			$this->connect();
			$databases = $this->getDatabases();
			//printf("<PRE>DATABASES2 = %s</PRE>\n",print_r($databases,1));
		}
		//printf("<PRE>SEARCH DATABASES = %s</PRE>\n",print_r($databases,1));
		foreach($databases as $database){
			//printf("<PRE>DATABASE = %s</PRE>\n",print_r($database,1));
			$this->connect($database);
			//printf("<PRE>CONNECT = %s</PRE>\n",print_r($this->database,1));
			$this->database = $database;
			$tables = array();
			if (!empty($_SESSION['table'])) {
				$tables[] = $_SESSION['table'];
			} else {
				$tables = $this->getTables($database, $this->driver);
			}
			//$tables = $this->getTables($database);
			//printf("<PRE>TABLES = %s</PRE>\n",print_r($tables,1));
			if (count($tables) == 0) continue;
			//$this->database = $database;
			foreach($tables as $table){
				//printf("<PRE>SEARCH TABLE = %s</PRE>\n",print_r($table,1));
				$this->table = $table;
				$this->model();
				$this->view();
			}
		}
	}
	
	public function model(){
		//$sql = "SHOW COLUMNS FROM $this->table";
		//$sql = "SHOW COLUMNS FROM $this->database.$this->table";
		//$sql = "SHOW COLUMNS FROM $this->table FROM $this->database";
		//$sql = "USE $this->database; SHOW COLUMNS FROM $this->table;";
		//$this->connect($this->database);
		//printf("<PRE>CONNECT = %s</PRE>\n",print_r($this->database,1));
		//printf("<PRE>TABLE = %s</PRE>\n",print_r($this->table,1));
		if ($this->driver == 'sqlite') {
			//$sql = "SELECT * FROM sqlite_master WHERE tbl_name=`$this->table`";
			//$sql = "SELECT * FROM sqlite_master";
			$sql = "SELECT * FROM `$this->table` LIMIT 1";
			//printf("<PRE>SQL = %s</PRE>\n",print_r($sql,1));
			$data = $this->DBO->query($sql);
			//printf("<PRE>DATA = %s</PRE>\n",print_r($data,1));
			if (count($data) == 0) return;
			$fields = array();
			foreach($data[0] as $key => $val){
				$fields[] = $key;
			}
			//printf("<PRE>FIELDS = %s</PRE>\n",print_r($fields,1));
		} else {
			$sql = "SHOW COLUMNS FROM `$this->table`;";
			//printf("<PRE>SQL = %s</PRE>\n",print_r($sql,1));
			$data = $this->DBO->query($sql);
			//printf("<PRE>DATA = %s</PRE>\n",print_r($data,1));
			if (count($data) == 0) return;
			$fields = array();
			foreach($data as $rec){
				$fields[] = $rec['Field'];
			}
		}
		//printf("<PRE>FIELDS = %s</PRE>\n",print_r($fields,1));
		//$tables = implode(',', $fields);
		//printf("<PRE>TABLES = %s</PRE>\n",print_r($tables,1));
		//$sql = "SELECT * FROM $this->table";
		//$sql.= " WHERE '%$this->query%' IN ($tables)";
		
		$sql = "SELECT * FROM `$this->table` WHERE ";
		$n=0;
		foreach($fields as $field){
			if ($n !== 0) $sql.= " OR ";
			$n++;
			$sql.= " `$field` LIKE '%$this->query%'";
		}
		//printf("<PRE>SQL = %s</PRE>\n",print_r($sql,1));
		$this->data = $this->DBO->query($sql);
		//printf("<PRE>DATA = %s</PRE>\n",print_r($this->data,1));
	}
	
	public function view(){
		//printf("<PRE>DATABASE = %s</PRE>\n",print_r($database,1));
		//printf("<PRE>TABLE    = %s</PRE>\n",print_r($table,1));
		//printf('<PRE>SESSION  = %s</PRE>'."\n", print_r($_SESSION,1));
		$n=0;
		
		if(!count($this->data)){
			return(false);
		}
		printf('<h2>%s.%s</h2>'."\n", $this->database, $this->table);
		
		printf('<table border="1" width="100%%">'."\n");
		foreach ($this->data as $rec) {
			if ($n == 0){
				printf('<thead>'."\n");
				printf('<tr>'."\n");
				printf('<th>#</th>'."\n");
				foreach ($rec as $key => $val) {
					printf('<th>%s</th>'."\n", strtoupper($key));
				}
				printf('</tr>'."\n");
				printf('</thead>'."\n");
				printf('<tbody>'."\n");
			}
			$n++;
			$m=0;
			foreach ($rec as $key => $val) {
				if ($m == 0) {
					printf('<tr onclick="parent.location.href=\'?page=record&database=%s&table=%s&key=%s&val=%s&recno=%s\'">'."\n", $this->database, $this->table, $key, $val, $n);
					printf('<th>%s</th>'."\n", $n);
				}
				printf('<td>%s</td>'."\n", print_r($val,1));
				$m++;
			}
			printf('</tr>'."\n");
		}
		printf('</tbody>'."\n");
		printf('</table>'."\n");
		printf('<br><br>'."\n");
	}
}

class Tools extends DBone {
	
	public function controller(){
		parent::controller();
	}
	
	public function model(){
		//$this->data = array('Columns','Search','Session','Version','Logout');
		$this->data = array('Pages','Extensions','PhpInfo','Server','Session','SQL','Versions','Logout');
		//printf("<PRE>DATA = %s</PRE>\n",print_r($data,1));
	}
	
	public function view(){
		$n=0;
		printf('<h1>%s</h1>'."\n", 'Tools');
		printf('<table border="1">'."\n");
		printf('<tbody>'."\n");
		printf('<tr>'."\n");
		printf('<td>'."\n");
		printf('<ul>'."\n");
		foreach ($this->data as $tool) {
			printf('<li><a href="?page=%s&database=%s" target="_parent">%s</li>'."\n", $tool, $this->database, ucfirst($tool));
		}
		printf('</ul>'."\n");
		printf('</td>'."\n");
		printf('</tr>'."\n");
		printf('</tbody>'."\n");
		printf('</table>'."\n");
	}
}

class CSV extends DBone {
	
	public function controller(){
		$this->driver   = !empty($_SESSION['driver'])   ? $_SESSION['driver']   : '';
		$this->database = !empty($_SESSION['database']) ? $_SESSION['database'] : '';
		$this->table    = !empty($_SESSION['table'])    ? $_SESSION['table']    : '';
		$this->query    = !empty($_REQUEST['query'])    ? $_REQUEST['query']    : '';
		
		//printf("<PRE>EXPORT DRIVER   = %s</PRE>\n",print_r($this->driver,1));
		//printf("<PRE>EXPORT DATABASE = %s</PRE>\n",print_r($this->database,1));
		//printf("<PRE>EXPORT TABLE    = %s</PRE>\n",print_r($this->table,1));
		//printf("<PRE>EXPORT QUERY    = %s</PRE>\n",print_r($this->query,1));
		
		$this->model();
		$this->view();
		
		### REDIRECT USING JAVASACRIPT
		//$this->redirect('records', $this->database, $this->table);
	}
	
	public function model(){
		$date = date('Y-m-d');
		$this->filename = sprintf('%s-%s.csv', $this->table, $date);
		$this->fields   = $this->getFields($this->database, $this->table);
		$this->data     = $this->getData($this->database, $this->table);
		
		$sql = "SELECT * from `$this->table`";
		//printf("<PRE>CSV SQL = %s</PRE>\n",print_r($sql,1));
		
		$this->data = $this->DBO->query($sql);
		//printf("<PRE>CSV DATA = %s</PRE>\n",print_r($this->data,1));
	}
	
	public function view(){
		header('Content-Type: text/csv; charset=utf-8');
		header('Content-Disposition: attachment; filename='.$this->filename);
		header('Pragma: no-cache');
		header('Expires: 0');
		header('Content-Transfer-Encoding: binary');
		header('Cache-Control: must-revalidate');
		
		$output = fopen("php://output", "w");
		$header = $this->fields;
		fputcsv($output, $header);
		foreach($this->data as $data){
			fputcsv($output, $data);
		}
		fclose($output);
	}
}

class Import extends DBone {
	
	public function controller(){
		
	}
	
	public function model(){
		
	}
	
	public function view(){
		
		
		
		
	}
}

class Export extends DBone {
	
	public function controller(){
		$this->driver   = !empty($_SESSION['driver'])   ? $_SESSION['driver']   : '';
		$this->dbhost   = !empty($_SESSION['dbhost'])   ? $_SESSION['dbhost']   : '';
		$this->database = !empty($_SESSION['database']) ? $_SESSION['database'] : '';
		$this->table    = !empty($_SESSION['table'])    ? $_SESSION['table']    : '';
		$this->query    = !empty($_REQUEST['query'])    ? $_REQUEST['query']    : '';
		$this->dbhost_flag = 0;
		
		//printf("<PRE>EXPORT DRIVER   = %s</PRE>\n",print_r($this->driver,1));
		//printf("<PRE>EXPORT DATABASE = %s</PRE>\n",print_r($this->database,1));
		//printf("<PRE>EXPORT TABLE    = %s</PRE>\n",print_r($this->table,1));
		//printf("<PRE>EXPORT QUERY    = %s</PRE>\n",print_r($this->query,1));
		
		$date = date('Y-m-d');
		if (!empty($this->table)) {
			$this->filename = sprintf('%s-%s.sql', $this->table, $date);
		} else if (!empty($this->database)) {
			$this->filename = sprintf('%s-%s.sql', $this->database, $date);
		} else {
			$this->filename = sprintf('%s-%s.sql', $this->dbhost, $date);
		}
		
		$databases = array();
		if (!empty($_SESSION['database'])) {
			
			$databases[] = $_SESSION['database'];
			//printf("<PRE>DATABASES1 = %s</PRE>\n",print_r($databases,1));
		} else {
			$this->connect();
			$databases = $this->getDatabases();
			//printf("<PRE>DATABASES2 = %s</PRE>\n",print_r($databases,1));
		}
		//printf("<PRE>SEARCH DATABASES = %s</PRE>\n",print_r($databases,1));
		
		$output = fopen("php://output", "w");
		
		foreach($databases as $database){
			$this->database_flag = 0;
			//printf("<PRE>DATABASE = %s</PRE>\n",print_r($database,1));
			$this->connect($database);
			//printf("<PRE>CONNECT = %s</PRE>\n",print_r($this->database,1));
			$this->database = $database;
			$tables = array();
			if (!empty($_SESSION['table'])) {
				$tables[] = $_SESSION['table'];
			} else {
				$tables = $this->getTables($database, $this->driver);
			}
			//$tables = $this->getTables($database);
			//printf("<PRE>TABLES = %s</PRE>\n",print_r($tables,1));
			if (count($tables) == 0) continue;
			//$this->database = $database;
			foreach($tables as $table){
				//printf("<PRE>SEARCH TABLE = %s</PRE>\n",print_r($table,1));
				$this->table = $table;
				$this->model();
				$this->view();
			}
		}
		fclose($output);
	}
	
	public function model(){
		$this->fields   = $this->getFields($this->database, $this->table);
		$this->data     = $this->getData($this->database, $this->table);
		
		$sql = "SELECT * from `$this->table`";
		//printf("<PRE>EXPORT SQL = %s</PRE>\n",print_r($sql,1));
		
		$this->data = $this->DBO->query($sql);
		//printf("<PRE>EXPORT DATA = %s</PRE>\n",print_r($this->data,1));
	}
	
	public function view(){
		
		//$output = fopen("php://output", "w");
		
		if (!$this->dbhost_flag) {
			$this->exportHeader($this->dbhost);
			$this->dbhost_flag = 1;
		}
		
		if (!$this->database_flag) {
			$this->exportDatabase($this->database);
			$this->database_flag = 1;
		}
		
		printf("\n");
		printf('--'."\n");
		printf('-- Table structure for table: %s'."\n", $this->table);
		printf('--'."\n");
		printf("\n");
		
		$this->connect($this->database);
		$sql = "SHOW CREATE TABLE `$this->table`";
		$data = $this->DBO->query($sql);
		//printf('CREATE TABLE: %s'."\n", print_r($data,1));
		$statement = !empty($data[0]['Create Table']) ? $data[0]['Create Table'] : '';
		
		$statement = str_replace('CREATE TABLE', 'CREATE TABLE IF NOT EXISTS', $statement);
		
		printf('%s;'."\n", $statement);
		
		printf("\n");
		printf('--'."\n");
		printf('-- Export data for table: %s'."\n", $this->table);
		printf('--'."\n");
		printf("\n");
		
		$fields = "`".implode("`,`", $this->fields)."`";
		foreach($this->data as $rec){
			$values = "'".implode("','", $rec)."'";
			printf('INSERT INTO `%s` (%s) VALUES (%s);'."\n", $this->table, $fields, $values);
		}
		//fclose($output);
	}
}

class Extensions extends DBone {
	
	public function controller(){
		parent::controller();
	}
	
	public function model(){
		//phpinfo();
	}
	
	public function view(){
		printf('<h2>%s</h2>'."\n", 'EXTENSIONS');
		printf('<table>'."\n");
		printf('<tr>'."\n");
		printf('<td>'."\n");
		printf('<PRE>%s</PRE>'."\n", print_r(get_loaded_extensions(),1));
		printf('</td>'."\n");
		printf('</tr>'."\n");
		printf('</table>'."\n");
	}
}

class Pages extends DBone {
	
	public function controller(){
		parent::controller();
	}
	
	public function model(){
		$this->data = array();
		$dir = '../dbone';
		$files = array_diff(scandir($dir), array('.', '..', '.DS_Store'));
		//printf('<PRE>FILES = %s</PRE>'."\n",print_r($files,1));
		foreach ($files as $file) {
			$page = substr($file, 0, strrpos($file, "."));
			$this->data[] = $page;
		}
		//printf('<PRE>DATA = %s</PRE>'."\n",print_r($this->data,1));
	}
	
	public function view(){
		printf('<h1>%s</h1>'."\n", 'Pages');
		printf('<table border="1">'."\n");
		printf('<thead>'."\n");
		printf('<tr>'."\n");
		printf('<th>#</th>'."\n");
		printf('<th>PAGE</th>'."\n");
		printf('</tr>'."\n");
		printf('</thead>'."\n");
		printf('<tbody>'."\n");
		$n=0;
		foreach ($this->data as $page) {
			$n++;
			printf('<tr>'."\n");
			printf('<th>%s</th>'."\n", $n);
			printf('<td><a href="?page=%s" target="_parent">%s</a></td>'."\n", $page, $page);
			printf('</tr>'."\n");
		}
		printf('</tbody>'."\n");
		printf('</table>'."\n");
	}
}

class PhpInfo extends DBone {
	
	public function controller(){
		parent::controller();
	}
	
	public function model(){
		//phpinfo();
	}
	
	public function view(){
		printf('<h2>%s</h2>'."\n", 'PHP Info');
		phpinfo();
	}
}

class Versions extends DBone {
	
	public function controller(){
		parent::controller();
	}
	
	public function model(){
		$this->data = array();
		$this->data['PHP Version']  = phpversion();
		$this->data['MySQL Client'] = mysqli_get_client_version();
		
		$this->connect();
		$sql = "SELECT VERSION()";
		$data = $this->DBO->query($sql);
		$this->data['MySQL Server'] = $data[0]['VERSION()'];
		
	}
	
	public function view(){
		printf('<h2>%s</h2>'."\n", 'Versions');
		printf('<table border="1">'."\n");
		foreach ($this->data as $key => $val) {
			printf('<tr>'."\n");
			printf('<th align="left">%s</th>'."\n", $key);
			printf('<td>%s</td>'."\n", $val);
			printf('</tr>'."\n");
		}
		printf('</table>'."\n");
	}
}

class Server extends DBone {
	
	public function controller(){
		parent::controller();
	}
	
	public function model(){
		//phpinfo();
	}
	
	public function view(){
		printf('<h2>%s</h2>'."\n", 'Server');
		printf('<table border="1">'."\n");
		printf('<tr>'."\n");
		printf('<td>'."\n");
		printf('<PRE>%s</PRE>'."\n",print_r($_SERVER,1));
		printf('</td>'."\n");
		printf('</tr>'."\n");
		printf('</table>'."\n");
	}
}

class Session extends DBone {
	
	public function controller(){
		parent::controller();
	}
	
	public function model(){
		foreach ($_SESSION as $key => $val) {
			$this->data[] = array('key' => $key, 'val' => $val);
		}
		//printf('<PRE>DATA = %s</PRE>'."\n",print_r($data,1));
	}
	
	public function view(){
		$n=0;
		printf('<h1>%s</h1>'."\n", 'Session');
		printf('<table border="1">'."\n");
		foreach ($this->data as $rec) {
			if ($n == 0){
				printf('<thead>'."\n");
				printf('<tr>'."\n");
				printf('<th>#</th>'."\n");
				foreach ($rec as $key => $val) {
					printf('<th>%s</th>'."\n", strtoupper($key));
				}
				printf('</tr>'."\n");
				printf('</thead>'."\n");
				printf('<tbody>'."\n");
			}
			$n++;
			printf('<tr>'."\n");
			printf('<th>%s</th>'."\n", $n);
			printf('<td>%s</td>'."\n", $rec['key']);
			printf('<td>%s</td>'."\n", print_r($rec['val'],1));
			printf('</tr>'."\n");
		}
		printf('</tbody>'."\n");
		printf('</table>'."\n");
	}
}

class DBO {
	
	public $PDO;
	
	public function __construct(){}
	
	public function connect($driver, $dbhost, $dbport, $charset, $dbuser, $dbpass, $database){
		if ($driver == 'sqlite') {
			if (empty($database)) {
				return(true);
			} else {
				//printf('<PRE>DBO.dbhost = %s</PRE>'."\n", print_r($dbhost,1));
				$dsn = "$driver:$dbhost/$database.db";
				//printf('<PRE>DBO.dsn = %s</PRE>'."\n", print_r($dsn,1));
				
			}
		} else {
			//$dsn = "$driver:host=$dbhost;port=$dbport;";
			$dsn = "$driver:host=$dbhost;port=$dbport;charset=$charset;dbname=$database;";
		}
		$options = array(
				\PDO::ATTR_ERRMODE => \PDO::ERRMODE_EXCEPTION,
				\PDO::ATTR_DEFAULT_FETCH_MODE => \PDO::FETCH_ASSOC,
				\PDO::ATTR_EMULATE_PREPARES => false,
		);
		try {
			
			//printf('<PRE>DBO.dsn     = %s</PRE>'."\n", print_r($dsn,1));
			//printf('<PRE>DBO.dbuser  = %s</PRE>'."\n", print_r($dbuser,1));
			//printf('<PRE>DBO.dbpass  = %s</PRE>'."\n", print_r($dbpass,1));
			//printf('<PRE>DBO.options = %s</PRE>'."\n", print_r($options,1));
			
			//$this->PDO = new \PDO($dsn, $dbuser, $dbpass);
			$this->PDO = new \PDO($dsn, $dbuser, $dbpass, $options);
			//printf('<PRE>DBO.connect.status = OK</PRE>'."\n");
			$status = true;
		} catch(PDOException $pex) {
			printf('<PRE>DBO.connect.error = %s</PRE>'."\n", print_r($pex->getMessage(),1));
			$status = $pex->errorInfo[2];
		}
		return $status;
	}
	
	function exec($sql) {
		try {
			$status = $this->PDO->exec($sql);
		} catch(\PDOException $pex) {
			$status = $pex->errorInfo[2];
		}
		return $status;
	}
	
	function execute2($sql) {
		try {
			$status = $this->PDO->execute($sql);
		} catch(\PDOException $pex) {
			$status = $pex->errorInfo[2];
		}
		return $status;
	}
	
	function getlastId() {
		try {
			$lastId = $this->PDO->lastInsertId();
		} catch(\PDOException $pex) {
			$status = $pex->errorInfo[2];
		}
		return $lastId;
	}
	
	function prepare($sql) {
		try {
			$stmt = $this->PDO->prepare($sql);
			return($stmt);
		} catch(\PDOException $pex) {
			$status = $pex->errorInfo[2];
			return($status);
		}
	}
	
	function query($sql) {
		try {
			//printf('<PRE>SQL = %s</PRE>'."\n", print_r($sql,1));
			$results = $this->PDO->query($sql);
			//printf('<PRE>RESULTS = %s</PRE>'."\n", print_r($results,1));
			$rows = $results->fetchAll();
			//printf('<PRE>ROWS = %s</PRE>'."\n", print_r($rows,1));
			//$rows = $this->PDO->query($sql, PDO::FETCH_ASSOC);
			return($rows);
		} catch(\PDOException $pex) {
			$status = $pex->errorInfo[2];
			return($status);
		}
	}
}

$DBone = new DBone();
$DBone->controller();
?>